/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.modules;

import java.util.LinkedList;
import java.util.Queue;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.core.modules.ImpactorModule;
import net.impactdev.impactor.relocations.io.github.classgraph.ClassGraph;
import net.impactdev.impactor.relocations.io.github.classgraph.ClassInfoList;
import net.impactdev.impactor.relocations.io.github.classgraph.ScanResult;

public final class ModuleInitializer {
    public Queue<Class<? extends ImpactorModule>> definitions = new LinkedList<Class<? extends ImpactorModule>>();
    public Queue<ImpactorModule> modules = new LinkedList<ImpactorModule>();

    public ModuleInitializer with(Class<? extends ImpactorModule> module) {
        this.definitions.add(module);
        return this;
    }

    public void construct(Impactor service) throws Exception {
        while (!this.definitions.isEmpty()) {
            Class<? extends ImpactorModule> type = this.definitions.poll();
            ImpactorModule module = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            module.factories(service.factories());
            module.builders(service.builders());
            module.services(service.services());
            module.subscribe(service.events());
            this.modules.add(module);
        }
    }

    public void initialize(Impactor service, PluginLogger logger) throws Exception {
        while (!this.modules.isEmpty()) {
            ImpactorModule module = this.modules.poll();
            module.init(service, logger);
        }
    }

    private void initializeModules(Impactor service) {
        ClassGraph graph = new ClassGraph().acceptPackages("net.impactdev.impactor").overrideClassLoaders(this.getClass().getClassLoader());
        try (ScanResult scan = graph.scan();){
            ClassInfoList list = scan.getClassesImplementing(ImpactorModule.class);
            list.stream().map(info -> info.loadClass(ImpactorModule.class)).map(type -> {
                try {
                    return (ImpactorModule)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).forEach(module -> {
                module.factories(service.factories());
                module.builders(service.builders());
                module.services(service.services());
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

