/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.platform.commands;

import java.io.BufferedOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.processing.CommandContainer;
import org.incendo.cloud.exception.CommandExecutionException;

@CommandContainer
@Permission(value={"impactor.commands.platform.base"})
public class PlatformCommands {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");

    @Command(value="impactor platform info")
    @Permission(value={"impactor.commands.platform.info"})
    public void info(CommandSource source2) {
        PrettyPrinter printer = new PrettyPrinter(80);
        printer.title("Platform Information");
        Impactor.instance().platform().info().print(printer);
        Path target = Paths.get("config", new String[0]).resolve("impactor").resolve("dumps").resolve("impactor-platform-" + formatter.format(LocalDateTime.now()) + ".txt");
        target.getParent().toFile().mkdirs();
        try (BufferedOutputStream buffer = new BufferedOutputStream(Files.newOutputStream(target.toFile().toPath(), new OpenOption[0]));
             PrintStream output = new PrintStream(buffer, true);){
            printer.print(output);
            ImpactorTranslations.PLATFORM_INFO_GENERATED.send(source2, Context.empty());
        }
        catch (Exception e) {
            throw new CommandExecutionException((Throwable)e);
        }
    }
}

