/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.platform.sources;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.platform.sources.SourceType;
import net.impactdev.impactor.api.platform.sources.metadata.MetadataKey;
import net.impactdev.impactor.core.utility.pointers.AbstractPointerCapable;
import net.kyori.adventure.text.Component;

public abstract class ImpactorPlatformSource
extends AbstractPointerCapable
implements PlatformSource {
    private final UUID uuid;
    private final SourceType type;
    private final Map<MetadataKey<?>, Supplier<?>> metadata;

    public ImpactorPlatformSource(UUID uuid, SourceType type) {
        this.uuid = uuid;
        this.type = type;
        this.metadata = new HashMap();
    }

    @Override
    public Locale locale() {
        return Locale.getDefault();
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    public SourceType type() {
        return this.type;
    }

    @Override
    public Component name() {
        if (this.type == SourceType.SERVER) {
            return Component.text((String)"Server");
        }
        return Component.empty();
    }

    @Override
    public <T> Optional<T> metadata(MetadataKey<T> key) {
        return Optional.ofNullable(this.metadata.get(key)).map(supplier -> supplier.get());
    }

    @Override
    public <T> void offer(MetadataKey<T> key, Supplier<T> instance) {
        if (instance == null) {
            this.metadata.remove(key);
            return;
        }
        this.metadata.put(key, instance);
    }
}

