/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.plugin;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.plugin.ImpactorPlugin;
import net.impactdev.impactor.api.plugin.components.Configurable;
import net.impactdev.impactor.api.scheduler.AbstractJavaScheduler;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.scheduler.v2.Schedulers;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.api.APIRegister;
import net.impactdev.impactor.core.api.ImpactorService;
import net.impactdev.impactor.core.commands.CommandsModule;
import net.impactdev.impactor.core.commands.ImpactorCommandRegistry;
import net.impactdev.impactor.core.configuration.ConfigModule;
import net.impactdev.impactor.core.configuration.ImpactorConfig;
import net.impactdev.impactor.core.economy.EconomyModule;
import net.impactdev.impactor.core.mail.MailModule;
import net.impactdev.impactor.core.modules.ModuleInitializer;
import net.impactdev.impactor.core.permissions.PermissionsModule;
import net.impactdev.impactor.core.plugin.ImpactorBootstrapper;
import net.impactdev.impactor.core.scheduler.AsyncScheduler;
import net.impactdev.impactor.core.scheduler.SchedulerModule;
import net.impactdev.impactor.core.text.TextModule;
import net.impactdev.impactor.core.translations.TranslationsModule;
import net.impactdev.impactor.core.utility.future.Futures;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public abstract class BaseImpactorPlugin
implements ImpactorPlugin,
Configurable {
    private static ImpactorPlugin instance;
    private final ImpactorBootstrapper bootstrapper;
    private final PluginMetadata metadata = PluginMetadata.builder().id("impactor").name("Impactor").version("@version@").build();
    private @MonotonicNonNull ModuleInitializer initializer;

    public BaseImpactorPlugin(ImpactorBootstrapper bootstrapper) {
        instance = this;
        this.bootstrapper = bootstrapper;
        this.bootstrapper.logger().info("Initializing API...");
        ImpactorService service = new ImpactorService();
        APIRegister.register(service);
    }

    public static BaseImpactorPlugin instance() {
        return (BaseImpactorPlugin)instance;
    }

    @Override
    public PluginMetadata metadata() {
        return this.metadata;
    }

    @Override
    public PluginLogger logger() {
        return this.bootstrapper.logger();
    }

    @Override
    public Path configurationDirectory() {
        return Paths.get("config", new String[0]).resolve("impactor");
    }

    @Override
    public ImpactorConfig configuration() {
        return null;
    }

    protected ModuleInitializer registerModules() {
        ModuleInitializer initializer = new ModuleInitializer();
        return initializer.with(ConfigModule.class).with(CommandsModule.class).with(EconomyModule.class).with(MailModule.class).with(PermissionsModule.class).with(SchedulerModule.class).with(TextModule.class).with(TranslationsModule.class);
    }

    @Override
    public void construct() {
        this.bootstrapper.logger().info("Registering modules...");
        this.initializer = this.registerModules();
        try {
            this.initializer.construct(Impactor.instance());
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.logger(), e);
        }
        this.bootstrapper.logger().info("Registering commands...");
        ImpactorCommandRegistry registry = new ImpactorCommandRegistry();
        registry.registerArgumentParsers();
        registry.registerAllCommands();
        this.setupSchedulers();
    }

    @Override
    public void setup() {
        this.bootstrapper.logger().info("Initializing modules...");
        Impactor service = Impactor.instance();
        try {
            this.initializer.initialize(service, this.logger());
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.logger(), e);
        }
    }

    @Override
    public void starting() {
    }

    @Override
    public void started() {
    }

    @Override
    public void shutdown() {
        this.logger().info("Shutting down schedulers...");
        AbstractJavaScheduler scheduler = (AbstractJavaScheduler)Impactor.instance().scheduler();
        scheduler.shutdownExecutor();
        scheduler.shutdownScheduler();
        Schedulers.shutdown(this.logger());
        Futures.shutdown();
        this.logger().info("Schedulers shutdown successfully!");
    }

    protected void setupSchedulers() {
        this.logger().info("Setting up schedulers...");
        Schedulers.register(Scheduler.ASYNCHRONOUS, new AsyncScheduler());
    }

    public InputStream resource(Function<Path, Path> target) {
        Path path = target.apply(Paths.get("impactor", new String[0]).resolve("assets"));
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(path.toString().replace("\\", "/"))).orElseThrow(() -> new IllegalArgumentException("Target resource not located"));
    }
}

