/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text;

import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.providers.BuilderProvider;
import net.impactdev.impactor.api.providers.FactoryProvider;
import net.impactdev.impactor.api.providers.ServiceProvider;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.text.pagination.PaginatedText;
import net.impactdev.impactor.api.text.placeholders.PlaceholderService;
import net.impactdev.impactor.core.modules.ImpactorModule;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.text.TextProcessorFactory;
import net.impactdev.impactor.core.text.pagination.ImpactorPaginatedText;
import net.impactdev.impactor.core.text.pagination.PaginationService;
import net.impactdev.impactor.core.text.placeholders.ImpactorPlaceholderService;
import net.impactdev.impactor.core.text.placeholders.ImpactorRegisterPlaceholdersEvent;
import net.impactdev.impactor.core.utility.events.EventPublisher;

public final class TextModule
implements ImpactorModule {
    @Override
    public void factories(FactoryProvider provider) {
        provider.register(TextProcessor.Factory.class, new TextProcessorFactory());
    }

    @Override
    public void services(ServiceProvider provider) {
        provider.register(PlaceholderService.class, new ImpactorPlaceholderService());
        provider.register(PaginationService.class, new PaginationService());
    }

    @Override
    public void builders(BuilderProvider provider) {
        provider.register(PaginatedText.PaginatedTextBuilder.class, ImpactorPaginatedText.ImpactorPaginationBuilder::new);
    }

    @Override
    public void init(Impactor impactor, PluginLogger logger) throws Exception {
        PlaceholderService service = impactor.services().provide(PlaceholderService.class);
        BaseImpactorPlugin.instance().logger().info("Firing placeholder registration event");
        EventPublisher.post(new ImpactorRegisterPlaceholdersEvent(service));
    }
}

