/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.pagination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.impactdev.impactor.api.text.pagination.PaginatedText;
import net.impactdev.impactor.core.text.pagination.PaginationCalculator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public final class ActivePagination {
    private static final Component SLASH_TEXT = Component.text((String)"/");
    private static final Component DIVIDER_TEXT = Component.space();
    private static final Component CONTINUATION_TEXT = Component.text((String)"...");
    private static final Page EMPTY_PAGE = new Page(Collections.emptyList());
    private final UUID id = UUID.randomUUID();
    @Nullable
    private final Component title;
    private final PaginatedText configuration;
    private final Component padding;
    private final int maxContentLinesPerPage;
    private final PaginationCalculator calculator;
    private final Component nextPageText;
    private final Component prevPageText;
    private int page;
    private List<Page> pages;

    ActivePagination(@Nullable Component title, PaginatedText configuration, List<Map.Entry<Component, Integer>> lines, PaginationCalculator calculator) {
        this.title = title;
        this.configuration = configuration;
        this.padding = configuration.padding();
        this.calculator = calculator;
        AtomicInteger maxContentLinesPerPage = new AtomicInteger(calculator.getMaxLinesPerPage() - 1);
        if (title != null) {
            maxContentLinesPerPage.addAndGet(-calculator.getLines(title));
        }
        this.configuration.header().ifPresent(header -> maxContentLinesPerPage.addAndGet(-calculator.getLines((Component)header)));
        this.configuration.footer().ifPresent(footer -> maxContentLinesPerPage.addAndGet(-calculator.getLines((Component)footer)));
        this.maxContentLinesPerPage = maxContentLinesPerPage.get();
        this.pages = this.constructPages(lines);
        this.nextPageText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00bb").color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.runCommand((String)("/pagination " + this.id + " next")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"/pagination next")))).insertion("/pagination " + this.id + " next")).build();
        this.prevPageText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00ab").color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.runCommand((String)("/pagination " + this.id + " prev")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"/pagination prev")))).insertion("/pagination " + this.id + " prev")).build();
    }

    public UUID id() {
        return this.id;
    }

    public void nextPage(Audience audience) {
        this.send(audience, this.page + 1);
    }

    public void previousPage(Audience audience) {
        this.send(audience, this.page - 1);
    }

    public void send(Audience audience, int page) {
        this.page = page;
        if (this.title != null) {
            audience.sendMessage(this.title);
        }
        this.configuration.header().ifPresent(arg_0 -> ((Audience)audience).sendMessage(arg_0));
        this.page(this.page).send(audience);
        this.configuration.footer().ifPresent(arg_0 -> ((Audience)audience).sendMessage(arg_0));
        Component text = this.calculateFooter(this.page);
        audience.sendMessage(this.calculator.center(text, this.padding));
    }

    private Page page(int page) {
        int size = this.pages.size();
        if (size == 0) {
            return EMPTY_PAGE;
        }
        if (page < 1) {
            throw new IllegalArgumentException(String.format("Page %d does not exist!", page));
        }
        if (page > size) {
            throw new IllegalArgumentException(String.format("Page %d is greater than the max of %d", page, size));
        }
        return this.pages.get(page - 1);
    }

    private List<Page> constructPages(List<Map.Entry<Component, Integer>> lines) {
        boolean lastPageNotEmpty;
        ArrayList<Page> results = new ArrayList<Page>();
        ArrayList<Object> currentPage = new ArrayList<Component>();
        int currentPageLines = 0;
        for (Map.Entry<Component, Integer> entry : lines) {
            boolean spillToNextPage;
            boolean finiteLinesPerPage = this.getMaxContentLinesPerPage() > 0;
            boolean willExceedPageLength = entry.getValue() + currentPageLines > this.getMaxContentLinesPerPage();
            boolean currentPageNotEmpty = currentPageLines != 0;
            boolean bl = spillToNextPage = finiteLinesPerPage && willExceedPageLength && currentPageNotEmpty;
            if (spillToNextPage) {
                this.padPage(currentPage, currentPageLines, true);
                currentPageLines = 0;
                results.add(new Page(currentPage));
                currentPage = new ArrayList();
            }
            currentPageLines += entry.getValue().intValue();
            currentPage.add(entry.getKey());
        }
        boolean bl = lastPageNotEmpty = currentPageLines > 0;
        if (lastPageNotEmpty) {
            if (!results.isEmpty()) {
                this.padPage(currentPage, currentPageLines, false);
            }
            results.add(new Page(currentPage));
        }
        return results;
    }

    private void padPage(List<Component> currentPage, int currentPageLines, boolean addContinuation) {
        int maxContentLinesPerPage = this.getMaxContentLinesPerPage();
        for (int i = currentPageLines; i < maxContentLinesPerPage; ++i) {
            if (addContinuation && i == maxContentLinesPerPage - 1) {
                currentPage.add(CONTINUATION_TEXT);
                continue;
            }
            currentPage.add(0, (Component)Component.empty());
        }
    }

    private int getMaxContentLinesPerPage() {
        return this.maxContentLinesPerPage;
    }

    private boolean hasPrevious(int page) {
        return page > 1;
    }

    private boolean hasNext(int page) {
        return page < this.pages.size();
    }

    private int getTotalPages() {
        return this.pages.size();
    }

    private Component calculateFooter(int currentPage) {
        boolean hasPrevious = this.hasPrevious(currentPage);
        boolean hasNext = this.hasNext(currentPage);
        TextComponent.Builder ret = Component.text();
        if (hasPrevious) {
            ((TextComponent.Builder)ret.append(this.prevPageText)).append(DIVIDER_TEXT);
        } else {
            ((TextComponent.Builder)ret.append((Component)Component.text((String)"\u00ab"))).append(DIVIDER_TEXT);
        }
        boolean needsDiv = false;
        int totalPages = this.getTotalPages();
        if (totalPages > 1) {
            ret.append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(currentPage)).clickEvent(ClickEvent.runCommand((String)("/pagination " + this.id + " " + currentPage)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("/pagination " + currentPage))))).insertion("/pagination " + this.id + " " + currentPage)).build());
            ret.append(SLASH_TEXT);
            ret.append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(totalPages)).clickEvent(ClickEvent.runCommand((String)("/pagination " + this.id + " " + totalPages)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("/pagination " + totalPages))))).insertion("/pagination " + this.id + " " + totalPages)).build());
            needsDiv = true;
        }
        if (needsDiv) {
            ret.append(DIVIDER_TEXT);
        }
        if (hasNext) {
            ret.append(this.nextPageText);
        } else {
            ret.append((Component)Component.text((String)"\u00bb"));
        }
        ret.color(this.padding.color());
        if (this.title != null) {
            ret.style(this.title.style());
        }
        return ret.build();
    }

    private static final class Page {
        private final List<Component> lines;

        public Page(List<Component> lines) {
            this.lines = lines;
        }

        public void send(Audience audience) {
            for (Component line : this.lines) {
                audience.sendMessage(line);
            }
        }
    }
}

