/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.pagination;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.text.pagination.PaginatedText;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.text.pagination.ActivePagination;
import net.impactdev.impactor.core.text.pagination.PaginationCalculator;
import net.impactdev.impactor.core.text.pagination.PaginationService;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class ImpactorPaginatedText
implements PaginatedText {
    static final Component DEFAULT_PADDING = Component.text((String)"=");
    private final Component title;
    private final Component header;
    private final Component footer;
    private final Component padding;
    private final List<Component> contents;
    private final int lines;

    public ImpactorPaginatedText(ImpactorPaginationBuilder builder) {
        this.title = builder.title;
        this.header = builder.header;
        this.footer = builder.footer;
        this.padding = builder.padding;
        this.contents = builder.contents;
        this.lines = builder.lines;
    }

    @Override
    public Optional<Component> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    public List<Component> contents() {
        return this.contents;
    }

    @Override
    public Optional<Component> header() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public Optional<Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public Component padding() {
        return this.padding;
    }

    @Override
    public int lines() {
        return this.lines;
    }

    @Override
    public void send(@NotNull Audience audience, int page) {
        Preconditions.checkNotNull((Object)audience, (Object)"The audience of a pagination cannot be null");
        PaginationCalculator calculator = new PaginationCalculator(this.lines);
        List<Map.Entry<Component, Integer>> counts = StreamSupport.stream(this.contents().spliterator(), false).map(input -> {
            int lines = calculator.getLines((Component)input);
            return Maps.immutableEntry((Object)input, (Object)lines);
        }).collect(Collectors.toList());
        Component title = this.title;
        title = title != null ? calculator.center(title, this.padding) : calculator.center((Component)Component.empty(), this.padding);
        ActivePagination active = new ActivePagination(title, this, counts, calculator);
        PaginationService service = Impactor.instance().services().provide(PaginationService.class);
        service.register(active.id(), active);
        try {
            active.send(audience, 1);
        }
        catch (Exception e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
    }

    public static class ImpactorPaginationBuilder
    implements PaginatedText.PaginatedTextBuilder {
        private Component title;
        private Component header;
        private Component footer;
        private Component padding;
        private List<Component> contents = new ArrayList<Component>();
        private int lines;

        @Override
        public PaginatedText.PaginatedTextBuilder title(Component title) {
            this.title = title;
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder contents(Component ... contents) {
            this.contents.addAll(Arrays.asList(contents));
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder contents(Collection<Component> contents) {
            this.contents.addAll(contents);
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder header(Component header) {
            this.header = header;
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder footer(Component footer) {
            this.footer = footer;
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder padding(Component padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public PaginatedText.PaginatedTextBuilder lines(int lines) {
            this.lines = lines;
            return this;
        }

        @Override
        public PaginatedText build() {
            return new ImpactorPaginatedText(this);
        }
    }
}

