/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.pagination;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Locale;
import java.util.PrimitiveIterator;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.core.text.pagination.ImpactorPaginatedText;
import net.impactdev.impactor.core.text.pagination.LanguageProcessor;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.CommentedConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.ConfigurateException;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import net.impactdev.impactor.relocations.org.spongepowered.math.GenericMath;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.translation.GlobalTranslator;

final class PaginationCalculator {
    private static final int LINE_WIDTH = 320;
    private static final String NON_UNICODE_CHARS;
    private static final int[] NON_UNICODE_CHAR_WIDTHS;
    private static final byte[] UNICODE_CHAR_WIDTHS;
    private final int lines;

    PaginationCalculator(int lines) {
        this.lines = lines;
    }

    int getMaxLinesPerPage() {
        return this.lines;
    }

    int getLines(Component text) {
        return (int)Math.ceil((double)this.width(text) / 320.0);
    }

    Component center(Component text, Component padding) {
        int inputLength = this.width(text);
        if (inputLength >= 320) {
            return text;
        }
        Component textWithSpaces = this.addSpaces((BuildableComponent<?, ?>)Component.space(), text);
        boolean addSpaces = this.width(textWithSpaces) <= 320;
        int paddingLength = this.width(padding);
        TextComponent.Builder output = Component.text();
        if (paddingLength < 1) {
            padding = ImpactorPaginatedText.DEFAULT_PADDING;
            paddingLength = this.width(padding);
        }
        if (inputLength == 0) {
            this.addPadding(padding, output, GenericMath.floor(320.0 / (double)paddingLength));
        } else {
            if (addSpaces) {
                text = textWithSpaces;
                inputLength = this.width(textWithSpaces);
            }
            int paddingNecessary = 320 - inputLength;
            int paddingCount = GenericMath.floor(paddingNecessary / paddingLength);
            int beforePadding = GenericMath.floor((double)paddingCount / 2.0);
            int afterPadding = paddingCount - beforePadding - 1;
            this.addPadding(padding, output, beforePadding);
            output.append(text);
            this.addPadding(padding, output, afterPadding);
        }
        return this.finalizeBuilder(text, output);
    }

    private Component finalizeBuilder(Component text, TextComponent.Builder build) {
        return ((TextComponent.Builder)build.style(text.style())).build();
    }

    private Component addSpaces(BuildableComponent<?, ?> spaces, Component text) {
        return spaces.toBuilder().style(text.style()).append(text.style(Style.empty())).append(spaces).build();
    }

    private void addPadding(Component padding, TextComponent.Builder build, int count) {
        if (count > 0) {
            if (padding instanceof TextComponent && padding.children().isEmpty()) {
                build.append((Component)Component.text((String)Strings.repeat((String)((TextComponent)padding).content(), (int)count), (Style)padding.style()));
            } else {
                build.append(Collections.nCopies(count, padding));
            }
        }
    }

    private int width(Component text) {
        Component child;
        ArrayDeque<Component> children = new ArrayDeque<Component>(1 + text.children().size());
        children.add(text);
        int total = 0;
        while ((child = (Component)children.pollFirst()) != null) {
            PrimitiveIterator.OfInt iterator2;
            for (Component grandchild : child.children()) {
                children.add(grandchild.style(child.style().merge(grandchild.style())));
            }
            if (child instanceof TextComponent) {
                iterator2 = ((TextComponent)child).content().codePoints().iterator();
            } else {
                if (!(child instanceof TranslatableComponent)) continue;
                TranslatableComponent component = (TranslatableComponent)child;
                MessageFormat global = GlobalTranslator.translator().translate(component.key(), Locale.US);
                if (global != null) {
                    iterator2 = global.toPattern().codePoints().iterator();
                    children.addAll(component.args());
                } else {
                    String mc = Impactor.instance().services().provide(LanguageProcessor.class).getOrDefault(component.key());
                    if (!mc.equals(component.key())) {
                        children.addAll(component.args());
                    }
                    iterator2 = mc.codePoints().iterator();
                }
            }
            boolean bold = child.style().hasDecoration(TextDecoration.BOLD);
            boolean newline = false;
            while (iterator2.hasNext()) {
                int code = iterator2.next();
                if (code == 10) {
                    if (newline) {
                        total += 320;
                        continue;
                    }
                    total = (int)Math.ceil((double)total / 320.0) * 320;
                    newline = true;
                    continue;
                }
                int width = this.width(code, bold);
                total += width;
                newline = false;
            }
        }
        return total;
    }

    private int width(int code, boolean bold) {
        int width;
        int nonUnicodeIdx = NON_UNICODE_CHARS.indexOf(code);
        if (code == 32) {
            width = 4;
        } else if (code > 0 && nonUnicodeIdx != -1) {
            width = NON_UNICODE_CHAR_WIDTHS[nonUnicodeIdx];
        } else if (UNICODE_CHAR_WIDTHS[code] != 0) {
            int temp = UNICODE_CHAR_WIDTHS[code] & 0xFF;
            int startColumn = temp >>> 4;
            int endColumn = temp & 0xF;
            width = endColumn + 1 - startColumn;
            width = width / 2 + 1;
        } else {
            width = 0;
        }
        if (bold && width > 0) {
            ++width;
        }
        return width;
    }

    static {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().url(PaginationCalculator.class.getResource("font-sizes.json"))).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            NON_UNICODE_CHARS = ((CommentedConfigurationNode)node.node(new Object[]{"non-unicode"})).getString();
            NON_UNICODE_CHAR_WIDTHS = ((CommentedConfigurationNode)node.node(new Object[]{"char-widths"})).get(int[].class, new int[0]);
            UNICODE_CHAR_WIDTHS = ((CommentedConfigurationNode)node.node(new Object[]{"glyph-widths"})).get(byte[].class, new byte[0]);
        }
        catch (ConfigurateException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

