/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.placeholders;

import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import net.impactdev.impactor.api.text.placeholders.PlaceholderParser;
import net.impactdev.impactor.api.text.placeholders.PlaceholderService;
import net.impactdev.impactor.core.text.placeholders.provided.ImpactorPlaceholder;
import net.impactdev.impactor.core.text.placeholders.provided.ImpactorPlaceholders;
import net.kyori.adventure.key.Key;

public final class ImpactorPlaceholderService
implements PlaceholderService {
    private final Map<Key, PlaceholderParser> placeholders = Maps.newHashMap();

    public ImpactorPlaceholderService() {
        Arrays.stream(ImpactorPlaceholders.class.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> ImpactorPlaceholder.class.isAssignableFrom(field.getType())).forEach(field -> {
            try {
                ImpactorPlaceholder placeholder = (ImpactorPlaceholder)field.get(null);
                this.register(placeholder.key(), placeholder.parser());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception processing field: " + field.getName(), e);
            }
        });
    }

    @Override
    public void register(Key key, PlaceholderParser parser) {
        this.placeholders.put(key, parser);
    }

    @Override
    public Map<Key, PlaceholderParser> parsers() {
        return this.placeholders;
    }

    @Override
    public String name() {
        return "Placeholder Service";
    }
}

