/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.placeholders.provided;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Optional;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.platform.sources.metadata.MetadataKeys;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.text.placeholders.PlaceholderArguments;
import net.impactdev.impactor.api.translations.metadata.LanguageInfo;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.core.economy.context.TransactionContext;
import net.impactdev.impactor.core.economy.context.TransferTransactionContext;
import net.impactdev.impactor.core.economy.placeholders.AccountPlaceholderParser;
import net.impactdev.impactor.core.text.placeholders.provided.ImpactorPlaceholder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;

public final class ImpactorPlaceholders {
    private static final DecimalFormat TWO_DECIMALS = new DecimalFormat("0.00");
    private static final DecimalFormat THREE_DECIMALS = new DecimalFormat("0.000");
    public static final ImpactorPlaceholder NAME = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("name"), (viewer, ctx) -> ImpactorPlaceholders.resolveSource(viewer, ctx).map(PlatformSource::name).orElse((Component)Component.empty()));
    public static final ImpactorPlaceholder UUID = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("uuid"), (viewer, ctx) -> (Component)ImpactorPlaceholders.resolveSource(viewer, ctx).map(PlatformSource::uuid).map(uuid -> Component.text((String)uuid.toString())).orElse(Component.empty()));
    public static final ImpactorPlaceholder POSITION = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("position"), (viewer, context) -> (Component)ImpactorPlaceholders.resolveSource(viewer, context).flatMap(source2 -> source2.metadata(MetadataKeys.POSITION)).map(pos -> Component.text((String)String.format("%.2f, %.2f, %.2f", pos.x(), pos.y(), pos.z()))).orElse(Component.empty()));
    public static final ImpactorPlaceholder TPS = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("tps"), (viewer, ctx) -> Component.text((String)TWO_DECIMALS.format(Impactor.instance().platform().performance().ticksPerSecond())));
    public static final ImpactorPlaceholder MSPT = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("mspt"), (viewer, ctx) -> Component.text((String)THREE_DECIMALS.format(Impactor.instance().platform().performance().averageTickDuration())));
    public static final ImpactorPlaceholder MEMORY_USAGE = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("memory_used"), (viewer, ctx) -> Component.text((long)Impactor.instance().platform().performance().memory().current()));
    public static final ImpactorPlaceholder MEMORY_ALLOCATED = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("memory_allocated"), (viewer, ctx) -> Component.text((long)Impactor.instance().platform().performance().memory().allocated()));
    public static final ImpactorPlaceholder MEMORY_TOTAL = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("memory_total"), (viewer, ctx) -> Component.text((long)Impactor.instance().platform().performance().memory().max()));
    public static final ImpactorPlaceholder ECONOMY_ACCOUNT = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("account"), new AccountPlaceholderParser());
    public static final ImpactorPlaceholder ECONOMY_CURRENCY = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("currency"), (viewer, ctx) -> ctx.request(Currency.class).orElse(EconomyService.instance().currencies().primary()).plural());
    public static final ImpactorPlaceholder ECONOMY_BALTOP = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("baltop"), (viewer, ctx) -> {
        PlaceholderArguments arguments = ctx.require(PlaceholderArguments.class);
        if (!arguments.hasNext()) {
            return Component.empty();
        }
        switch (arguments.pop()) {
            case "ranking": {
                return Component.text((int)ctx.require(Integer.class));
            }
        }
        return Component.empty();
    });
    public static final ImpactorPlaceholder ECONOMY_TRANSACTION = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("economy_transaction"), (viewer, ctx) -> {
        PlaceholderArguments arguments = ctx.require(PlaceholderArguments.class);
        if (!arguments.hasNext()) {
            return Component.empty();
        }
        Currency currency = ctx.require(Currency.class);
        Optional<TransactionContext> transaction = ctx.request(TransactionContext.class);
        if (transaction.isPresent()) {
            String option;
            TransactionContext context = transaction.get();
            switch (option = arguments.pop()) {
                case "type": {
                    return Component.text((String)context.type().name());
                }
                case "before": {
                    return currency.format(context.before());
                }
                case "after": {
                    return currency.format(context.after());
                }
                case "reason": {
                    return Component.text((String)context.result().name());
                }
            }
        } else {
            String option;
            TransferTransactionContext context = ctx.require(TransferTransactionContext.class);
            switch (option = arguments.pop()) {
                case "type": {
                    return Component.text((String)EconomyTransactionType.TRANSFER.name());
                }
                case "result": {
                    return Component.text((String)context.result().name());
                }
                case "source": {
                    String st;
                    switch (st = arguments.pop()) {
                        case "before": {
                            return currency.format(context.from().before());
                        }
                        case "after": {
                            return currency.format(context.from().after());
                        }
                    }
                }
                case "recipient": {
                    String rt;
                    switch (rt = arguments.pop()) {
                        case "before": {
                            return currency.format(context.to().before());
                        }
                        case "after": {
                            return currency.format(context.to().after());
                        }
                    }
                }
            }
        }
        return Component.empty();
    });
    public static final ImpactorPlaceholder PAYMENT = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("payment"), (viewer, ctx) -> {
        Currency currency = ctx.require(Currency.class);
        BigDecimal amount = ctx.require(BigDecimal.class);
        return currency.format(amount);
    });
    public static final ImpactorPlaceholder LANGUAGE = new ImpactorPlaceholder(ImpactorPlaceholders.impactor("language"), (viewer, ctx) -> {
        PlaceholderArguments arguments = ctx.require(PlaceholderArguments.class);
        if (!arguments.hasNext()) {
            return Component.empty();
        }
        LanguageInfo info = ctx.require(LanguageInfo.class);
        switch (arguments.pop()) {
            case "id": {
                return Component.text((String)info.locale().toLanguageTag());
            }
            case "name": {
                return Component.text((String)info.locale().getDisplayName());
            }
            case "progress": {
                int progress = info.progress();
                return TextProcessor.mini().parse("<transition:red:yellow:green:" + (double)progress / 100.0 + ">" + progress + "%");
            }
            case "contributor": {
                String contributor = ctx.require(String.class);
                return Component.text((String)contributor);
            }
        }
        return Component.empty();
    });

    private static Key impactor(@Subst(value="dummy") @Pattern(value="[a-z0-9_\\-./]+") String key) {
        return Key.key((String)"impactor", (String)key);
    }

    private static Optional<PlatformSource> resolveSource(PlatformSource viewer, Context context) {
        return context.request(PlatformSource.class).or(() -> context.request(PlatformPlayer.class)).or(() -> context.request(PlatformSource.SOURCE)).or(() -> context.request(PlatformPlayer.PLAYER)).or(() -> Optional.ofNullable(viewer));
    }
}

