/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.processors;

import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.text.placeholders.ComponentModifiers;
import net.impactdev.impactor.api.text.placeholders.PlaceholderParser;
import net.impactdev.impactor.api.text.placeholders.PlaceholderService;
import net.impactdev.impactor.api.utility.Context;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class LegacyTextProcessor
implements TextProcessor {
    private static final Pattern TOKENIZER = Pattern.compile("((?=([{]{2}|[}]{2})|(?<=([{]{2}|[}]{2}))))");
    private static final Pattern PLACEHOLDER = Pattern.compile("(?<placeholder>[\\w-:]+)(\\|(?<arguments>.+))?");
    private static final Pattern LAST_FORMATS = Pattern.compile("(&([a-fk-or0-9]|#[a-f0-9]{6})){1,2}$", 2);
    private static final Map<Character, TextFormat> FORMATTERS = Maps.newHashMap();
    private final Supplier<PlaceholderService> service = Suppliers.memoize(() -> Impactor.instance().services().provide(PlaceholderService.class));
    private final LegacyComponentSerializer serializer;

    public LegacyTextProcessor(char character) {
        this.serializer = LegacyComponentSerializer.builder().character(character).hexColors().build();
    }

    @Override
    @NotNull
    public Component parse(@NotNull PlatformSource viewer, String raw, Context context) {
        Component result = null;
        List<Component> tokens = this.tokenize(viewer, raw, context);
        for (Component token : tokens) {
            if (result == null) {
                result = token;
                continue;
            }
            result = result.append(token);
        }
        return Objects.requireNonNull(result);
    }

    private List<Component> tokenize(PlatformSource viewer, String input, Context context) {
        Map<Key, PlaceholderParser> parsers = this.service.get().parsers();
        List split = Splitter.on((Pattern)TOKENIZER).splitToList((CharSequence)input);
        ArrayList result = Lists.newArrayList();
        ArrayList decorations = Lists.newArrayList();
        StringBuilder cache = new StringBuilder();
        for (int i = 0; i < split.size(); ++i) {
            if (((String)split.get(i)).equals("{{") && ((String)split.get(i + 2)).equals("}}")) {
                if (cache.length() > 0) {
                    String built = cache.toString();
                    cache = new StringBuilder();
                    result.add(this.serializer.deserialize(built));
                    Matcher matcher = LAST_FORMATS.matcher(built);
                    if (matcher.find()) {
                        Arrays.stream(matcher.group().split("&")).filter(in -> !in.isEmpty()).map(in -> {
                            if (in.length() == 1) {
                                return FORMATTERS.get(Character.valueOf(in.charAt(0)));
                            }
                            try {
                                return TextColor.color((int)Integer.parseInt(in.substring(1), 16));
                            }
                            catch (NumberFormatException e) {
                                return null;
                            }
                        }).filter(Objects::nonNull).forEach(decorations::add);
                    }
                }
                AtomicReference<Object> parsed = new AtomicReference<Object>();
                Matcher placeholder = PLACEHOLDER.matcher((CharSequence)split.get(i + 1));
                if (!placeholder.find()) {
                    parsed.set(this.serializer.deserialize("{{" + (String)split.get(i + 1) + "}}"));
                } else {
                    String rawKey = placeholder.group("placeholder");
                    Key key = rawKey.contains(":") ? Key.key((String)rawKey) : Key.key((String)"unknown", (String)rawKey);
                    parsed.set(parsers.getOrDefault(key, (ignore, ctx) -> ((TextComponent)Component.text((String)"{{").append((Component)Component.text((String)rawKey))).append((Component)Component.text((String)"}}"))).parse(viewer, context));
                    String arguments = placeholder.group("arguments");
                    if (arguments != null) {
                        for (int c = 0; c < arguments.length(); ++c) {
                            char arg = arguments.charAt(c);
                            parsed.set(ComponentModifiers.transform(arg, (Component)parsed.get()));
                        }
                    }
                }
                decorations.forEach(format -> parsed.set(((Component)parsed.get()).style(parent -> {
                    if (format instanceof TextColor) {
                        parent.color((TextColor)format);
                    } else {
                        parent.decoration((TextDecoration)format, TextDecoration.State.TRUE);
                    }
                })));
                result.add((Component)parsed.get());
                i += 2;
                continue;
            }
            cache.append((String)split.get(i));
        }
        if (cache.length() > 0) {
            result.add(this.serializer.deserialize(cache.toString()));
        }
        return result;
    }

    static {
        FORMATTERS.put(Character.valueOf('0'), (TextFormat)NamedTextColor.BLACK);
        FORMATTERS.put(Character.valueOf('1'), (TextFormat)NamedTextColor.DARK_BLUE);
        FORMATTERS.put(Character.valueOf('2'), (TextFormat)NamedTextColor.DARK_GREEN);
        FORMATTERS.put(Character.valueOf('3'), (TextFormat)NamedTextColor.DARK_AQUA);
        FORMATTERS.put(Character.valueOf('4'), (TextFormat)NamedTextColor.DARK_RED);
        FORMATTERS.put(Character.valueOf('5'), (TextFormat)NamedTextColor.DARK_PURPLE);
        FORMATTERS.put(Character.valueOf('6'), (TextFormat)NamedTextColor.GOLD);
        FORMATTERS.put(Character.valueOf('7'), (TextFormat)NamedTextColor.GRAY);
        FORMATTERS.put(Character.valueOf('8'), (TextFormat)NamedTextColor.DARK_GRAY);
        FORMATTERS.put(Character.valueOf('9'), (TextFormat)NamedTextColor.BLUE);
        FORMATTERS.put(Character.valueOf('a'), (TextFormat)NamedTextColor.GREEN);
        FORMATTERS.put(Character.valueOf('b'), (TextFormat)NamedTextColor.AQUA);
        FORMATTERS.put(Character.valueOf('c'), (TextFormat)NamedTextColor.RED);
        FORMATTERS.put(Character.valueOf('d'), (TextFormat)NamedTextColor.LIGHT_PURPLE);
        FORMATTERS.put(Character.valueOf('e'), (TextFormat)NamedTextColor.YELLOW);
        FORMATTERS.put(Character.valueOf('f'), (TextFormat)NamedTextColor.WHITE);
        FORMATTERS.put(Character.valueOf('k'), (TextFormat)TextDecoration.OBFUSCATED);
        FORMATTERS.put(Character.valueOf('l'), (TextFormat)TextDecoration.BOLD);
        FORMATTERS.put(Character.valueOf('m'), (TextFormat)TextDecoration.STRIKETHROUGH);
        FORMATTERS.put(Character.valueOf('n'), (TextFormat)TextDecoration.UNDERLINED);
        FORMATTERS.put(Character.valueOf('o'), (TextFormat)TextDecoration.ITALIC);
    }
}

