/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.text.processors;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.text.placeholders.PlaceholderArguments;
import net.impactdev.impactor.api.text.placeholders.PlaceholderParser;
import net.impactdev.impactor.api.text.placeholders.PlaceholderService;
import net.impactdev.impactor.api.utility.Context;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MiniMessageProcessor
implements TextProcessor {
    private final Supplier<PlaceholderService> service = Suppliers.memoize(() -> Impactor.instance().services().provide(PlaceholderService.class));
    private final MiniMessage mini;

    public MiniMessageProcessor(MiniMessage service) {
        this.mini = service;
    }

    @Override
    @NotNull
    public Component parse(@Nullable PlatformSource viewer, String raw, Context context) {
        return this.mini.deserialize(raw, this.createResolvers(viewer, context));
    }

    private TagResolver[] createResolvers(PlatformSource viewer, Context context) {
        Map<Key, PlaceholderParser> parsers = this.service.get().parsers();
        HashMap resolvers = Maps.newHashMap();
        HashMap results = Maps.newHashMap();
        parsers.keySet().stream().map(Key::namespace).distinct().forEach(namespace -> resolvers.computeIfAbsent(namespace, in -> TagResolver.resolver((String)in, (args2, ctx) -> {
            Tag.Argument path = args2.popOr("Invalid placeholder key, no path specified");
            Key target = Key.key((String)namespace, (String)path.lowerValue());
            PlaceholderArguments arguments = PlaceholderArguments.create(args2);
            context.append(PlaceholderArguments.class, arguments);
            PlaceholderResolver resolver = new PlaceholderResolver(target, arguments);
            Component result = results.computeIfAbsent(resolver, r -> r.resolve(target, viewer, arguments, context, parsers));
            return Tag.selfClosingInserting((Component)result);
        })));
        return resolvers.values().toArray(new TagResolver[0]);
    }

    private static final class PlaceholderResolver {
        private final Key key;
        private final PlaceholderArguments arguments;
        private @MonotonicNonNull Component resolved;

        public PlaceholderResolver(Key key, PlaceholderArguments arguments) {
            this.key = key;
            this.arguments = arguments;
        }

        @NotNull
        public Component resolve(Key target, PlatformSource viewer, PlaceholderArguments arguments, Context context, Map<Key, PlaceholderParser> parsers) {
            if (this.resolved == null) {
                PlaceholderParser parser = parsers.get(target);
                if (parser == null) {
                    StringBuilder placeholder = new StringBuilder("<" + target.asString());
                    while (arguments.hasNext()) {
                        placeholder.append(":").append(arguments.pop());
                    }
                    placeholder.append(">");
                    this.resolved = Component.text((String)placeholder.toString());
                    return this.resolved;
                }
                this.resolved = parser.parse(viewer, context);
                return this.resolved;
            }
            return this.resolved;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlaceholderResolver that = (PlaceholderResolver)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.arguments);
        }
    }
}

