/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations;

import java.nio.file.Paths;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.providers.BuilderProvider;
import net.impactdev.impactor.api.providers.FactoryProvider;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.TranslationProvider;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.core.modules.ImpactorModule;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.translations.builders.ImpactorTranslationManagerBuilder;
import net.impactdev.impactor.core.translations.builders.ImpactorTranslationRepositoryBuilder;
import net.impactdev.impactor.core.translations.components.ImpactorTranslationProvider;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import net.impactdev.impactor.core.translations.internal.TranslationsConfig;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class TranslationsModule
implements ImpactorModule {
    public static @MonotonicNonNull Config config;

    @Override
    public void factories(FactoryProvider provider) {
        provider.register(TranslationProvider.Factory.class, new ImpactorTranslationProvider.TranslationProviderFactory());
    }

    @Override
    public void builders(BuilderProvider provider) {
        provider.register(TranslationManager.TranslationManagerBuilder.class, ImpactorTranslationManagerBuilder::new);
        provider.register(TranslationRepository.RepositoryBuilder.class, ImpactorTranslationRepositoryBuilder::new);
    }

    @Override
    public void init(Impactor impactor, PluginLogger logger) throws Exception {
        config = (Config)Config.builder().provider(TranslationsConfig.class).path(Paths.get("config", new String[0]).resolve("impactor").resolve("translations").resolve("translations.conf")).provideIfMissing(() -> BaseImpactorPlugin.instance().resource(root -> root.resolve("configs").resolve("translations.conf"))).build();
        logger.info("Initializing translations...");
        ImpactorTranslations.MANAGER.initialize();
        ImpactorTranslations.MANAGER.refresh();
    }
}

