/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.builders;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Supplier;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.core.translations.ImpactorTranslationManager;
import org.jetbrains.annotations.NotNull;

public class ImpactorTranslationManagerBuilder
implements TranslationManager.TranslationManagerBuilder {
    public TranslationRepository repository;
    public Locale defaultLocale;
    public Path path;
    public TextProcessor processor;
    public PluginMetadata metadata;
    public Supplier<InputStream> supplier;

    @Override
    public TranslationManager.TranslationManagerBuilder repository(@NotNull TranslationRepository repository) {
        this.repository = repository;
        return this;
    }

    @Override
    public TranslationManager.TranslationManagerBuilder fallback(@NotNull Locale locale) {
        this.defaultLocale = locale;
        return this;
    }

    @Override
    public TranslationManager.TranslationManagerBuilder path(@NotNull Path path) {
        this.path = path;
        return this;
    }

    @Override
    public TranslationManager.TranslationManagerBuilder processor(@NotNull TextProcessor processor) {
        this.processor = processor;
        return this;
    }

    @Override
    public TranslationManager.TranslationManagerBuilder provided(@NotNull Supplier<InputStream> supplier) {
        this.supplier = supplier;
        return this;
    }

    @Override
    public TranslationManager build() {
        return new ImpactorTranslationManager(this);
    }
}

