/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.impactdev.impactor.api.translations.repository.TranslationEndpoint;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.core.translations.repository.ImpactorTranslationRepository;
import org.jetbrains.annotations.NotNull;

public class ImpactorTranslationRepositoryBuilder
implements TranslationRepository.RepositoryBuilder {
    public final Map<TranslationEndpoint, String> urls = new HashMap<TranslationEndpoint, String>();
    public Supplier<Boolean> rule;
    public long maxBundleSize = 0x100000L;
    public long maxCacheAge = TimeUnit.HOURS.toMillis(24L);

    @Override
    public TranslationRepository.RepositoryBuilder endpoint(@NotNull TranslationEndpoint endpoint, @NotNull String baseURL) {
        this.urls.put(endpoint, baseURL);
        return this;
    }

    @Override
    public TranslationRepository.RepositoryBuilder refreshWhen(@NotNull Supplier<Boolean> rule) {
        this.rule = rule;
        return this;
    }

    @Override
    public TranslationRepository.RepositoryBuilder maxBundleSize(long size) {
        this.maxBundleSize = size;
        return this;
    }

    @Override
    public TranslationRepository.RepositoryBuilder maxCacheAge(long age) {
        this.maxCacheAge = age;
        return this;
    }

    @Override
    public TranslationRepository build() {
        return new ImpactorTranslationRepository(this);
    }
}

