/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.repository;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LimitedInputStream
extends FilterInputStream
implements Closeable {
    private final long limit;
    private long count;

    public LimitedInputStream(InputStream inputStream2, long limit) {
        super(inputStream2);
        this.limit = limit;
    }

    private void checkLimit() throws IOException {
        if (this.count > this.limit) {
            throw new IOException("Limit exceeded");
        }
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }
}

