/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.repository;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.future.Futures;
import net.impactdev.impactor.relocations.okhttp3.OkHttpClient;
import net.impactdev.impactor.relocations.okhttp3.Request;
import net.impactdev.impactor.relocations.okhttp3.Response;

public class TranslationsClient {
    public static final String USER_AGENT = "Impactor/Translations";
    private final OkHttpClient client = new OkHttpClient.Builder().callTimeout(15L, TimeUnit.SECONDS).build();

    void shutdown() {
        ExecutorService service = this.client.dispatcher().executorService();
        service.shutdown();
        try {
            this.client.connectionPool().evictAll();
            Optional.ofNullable(this.client.cache()).ifPresent(cache -> {
                try {
                    cache.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            if (!service.awaitTermination(10L, TimeUnit.SECONDS)) {
                BaseImpactorPlugin.instance().logger().severe("Timed out waiting for the Impactor worker thread pool to terminate");
                Futures.reportRunningTasks(thread2 -> thread2.getName().startsWith("OkHttp"));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    Response makeRequest(Request request) throws Exception {
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            response.close();
            throw new RuntimeException("Request was unsuccessful: " + response.code() + " - " + response.message());
        }
        return response;
    }
}

