/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.utility.events;

import java.util.concurrent.atomic.AtomicInteger;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.events.ImpactorEvent;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.kyori.event.PostResult;

public final class EventPublisher {
    public static void post(ImpactorEvent event) {
        PostResult result = Impactor.instance().events().post((Object)event);
        try {
            result.raise();
        }
        catch (PostResult.CompositeException exception) {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.title("Event Subscriber Exceptions").consume(p -> {
                int tracked = exception.result().exceptions().size();
                p.add("Exceptions were encountered while processing event subscribers to").add("the given event type: " + event.getClass().getSimpleName()).newline().add("These errors will now be listed below...");
            }).hr('-').consume(p -> {
                p.newline();
                AtomicInteger index = new AtomicInteger(1);
                exception.result().exceptions().forEach((subscriber, error) -> {
                    p.add("%d: %s", index.getAndIncrement(), subscriber);
                    p.add((Throwable)error, 2);
                });
                p.newline();
            });
            printer.log(BaseImpactorPlugin.instance().logger());
        }
    }
}

