/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.utility.future;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.utility.future.ThrowingRunnable;

public final class Futures {
    public static final ExecutorService ASYNC_EXECUTOR = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("Impactor Async Executor - #%d").setDaemon(true).build());

    public static <T> CompletableFuture<T> execute(Callable<T> method) {
        return Futures.execute((Executor)ASYNC_EXECUTOR, method);
    }

    public static <T> CompletableFuture<T> execute(Executor executor, Callable<T> method) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return method.call();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                throw new CompletionException(e);
            }
        }, executor);
    }

    public static CompletableFuture<Void> execute(ThrowingRunnable runnable2) {
        return Futures.execute((Executor)ASYNC_EXECUTOR, runnable2);
    }

    public static CompletableFuture<Void> execute(Executor executor, ThrowingRunnable runnable2) {
        return CompletableFuture.runAsync(() -> {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                throw new CompletionException(e);
            }
        }, executor);
    }

    public static <T> CompletableFuture<T> makeFutureDelayed(Callable<T> callable, long delay, TimeUnit unit) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, r -> scheduler.schedule(() -> ASYNC_EXECUTOR.execute(r), delay, unit));
    }

    public static <T> CompletableFuture<T> makeFutureDelayed(Callable<T> callable, Executor executor, long delay, TimeUnit unit) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new CompletionException(e);
            }
        }, r -> scheduler.schedule(() -> executor.execute(r), delay, unit));
    }

    public static CompletableFuture<Void> timed(ThrowingRunnable runnable2, long duration, TimeUnit unit) {
        return Futures.execute(runnable2).acceptEither((CompletionStage)Futures.timeoutAfter(duration, unit), ignore -> {});
    }

    public static CompletableFuture<Void> timed(ThrowingRunnable runnable2, Executor executor, long duration, TimeUnit unit) {
        return Futures.execute(executor, runnable2).acceptEither((CompletionStage)Futures.timeoutAfter(duration, unit), ignore -> {});
    }

    public static <T> CompletableFuture<T> timed(Callable<T> callable, long duration, TimeUnit unit) {
        return Futures.execute(callable).applyToEither((CompletionStage)Futures.timeoutAfter(duration, unit), value -> value);
    }

    public static <W> CompletableFuture<W> timeoutAfter(long timeout2, TimeUnit unit) {
        return Futures.makeFutureDelayed(() -> {
            throw new TimeoutException();
        }, timeout2, unit);
    }

    public static <W> CompletableFuture<W> timeoutAfter(Executor executor, long timeout2, TimeUnit unit) {
        return Futures.makeFutureDelayed(() -> {
            throw new TimeoutException();
        }, executor, timeout2, unit);
    }

    public static <W> CompletableFuture<W> timeoutAfter(Runnable runnable2, Executor executor, long timeout2, TimeUnit unit) {
        return Futures.makeFutureDelayed(() -> {
            runnable2.run();
            throw new TimeoutException();
        }, executor, timeout2, unit);
    }

    public static void shutdown() {
        ASYNC_EXECUTOR.shutdown();
        try {
            if (!ASYNC_EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS)) {
                BaseImpactorPlugin.instance().logger().severe("Timed out waiting for the Impactor worker thread pool to terminate");
                Futures.reportRunningTasks(thread2 -> thread2.getName().startsWith("Impactor Async Executor"));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void reportRunningTasks(Predicate<Thread> predicate) {
        Thread.getAllStackTraces().forEach((thread2, stack) -> {
            if (predicate.test((Thread)thread2)) {
                BaseImpactorPlugin.instance().logger().warn("Thread " + thread2.getName() + " is blocked, and may be the reason for the slow shutdown!\n" + Arrays.stream(stack).map(el -> "  " + el).collect(Collectors.joining("\n")));
            }
        });
    }
}

