/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric.integrations;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Optional;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.events.ImpactorEvent;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.text.events.RegisterPlaceholdersEvent;
import net.impactdev.impactor.api.text.placeholders.PlaceholderArguments;
import net.impactdev.impactor.api.text.placeholders.PlaceholderService;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.fabric.platform.FabricPlatform;
import net.impactdev.impactor.minecraft.api.text.AdventureTranslator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.event.EventBus;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderAPIIntegration {
    public String name() {
        return "Placeholder API";
    }

    public void subscribe(PluginLogger logger, EventBus<ImpactorEvent> bus) {
        logger.info("Integrating with PlaceholderAPI...");
        bus.subscribe(RegisterPlaceholdersEvent.class, event -> Placeholders.getPlaceholders().forEach((location, handler) -> {
            Key key = Key.key((String)location.toString());
            if (key.namespace().equals("impactor")) {
                return;
            }
            event.register(key, (viewer, context) -> {
                FabricPlatform platform = (FabricPlatform)Impactor.instance().platform();
                MinecraftServer server = platform.server();
                class_3222 player = context.request(PlatformPlayer.class).map(PlatformSource::uuid).or(() -> Optional.ofNullable(viewer).map(PlatformSource::uuid)).map(p -> server.method_3760().method_14602(p)).orElse(null);
                PlaceholderArguments arguments = context.require(PlaceholderArguments.class);
                PlaceholderContext ctx = player != null ? PlaceholderContext.of((class_3222)player) : PlaceholderContext.of((MinecraftServer)server);
                return AdventureTranslator.fromNative(handler.onPlaceholderRequest(ctx, arguments.popOrDefault()).text());
            });
        }));
    }

    public void registerToPapi() {
        PlaceholderService placeholders = Impactor.instance().services().provide(PlaceholderService.class);
        placeholders.parsers().forEach((key, parser) -> Placeholders.register((class_2960)new class_2960(key.namespace(), key.value()), (context, argument) -> {
            Context ctx = Context.empty();
            if (argument != null) {
                ctx.append(PlaceholderArguments.class, new PlaceholderArguments(new String[]{argument}));
            } else {
                ctx.append(PlaceholderArguments.class, new PlaceholderArguments(new String[0]));
            }
            PlatformSource viewer = this.viewer(context);
            if (viewer == null) {
                return PlaceholderResult.invalid();
            }
            Component result = parser.parse(viewer, ctx);
            return PlaceholderResult.value((class_2561)AdventureTranslator.toNative(result));
        }));
    }

    @Nullable
    private PlatformSource viewer(PlaceholderContext context) {
        if (context.hasPlayer()) {
            return PlatformPlayer.getOrCreate(context.player().method_5667());
        }
        if (context.server() != null) {
            return PlatformSource.server();
        }
        if (context.hasEntity()) {
            return PlatformSource.factory().fromID(context.entity().method_5667());
        }
        return null;
    }
}

