/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric.platform.sources;

import java.util.Optional;
import java.util.UUID;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.sources.PlatformSource;
import net.impactdev.impactor.api.platform.sources.SourceType;
import net.impactdev.impactor.api.platform.sources.metadata.MetadataKeys;
import net.impactdev.impactor.fabric.FabricImpactorBootstrap;
import net.impactdev.impactor.fabric.platform.sources.FabricPlatformPlayer;
import net.impactdev.impactor.fabric.platform.sources.FabricPlatformSource;
import net.impactdev.impactor.minecraft.platform.metadata.GameMetadataKeys;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2d;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector3d;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1297;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class FabricPlatformFactory
implements PlatformSource.Factory,
PlatformPlayer.Factory {
    private final Cache<UUID, PlatformSource> cache = Caffeine.newBuilder().build();

    @Override
    public PlatformSource server() {
        return this.cache.get(PlatformSource.SERVER_UUID, uuid -> new FabricPlatformSource(PlatformSource.SERVER_UUID, SourceType.SERVER));
    }

    @Override
    public PlatformSource fromID(UUID uuid) {
        if (uuid.equals(PlatformSource.SERVER_UUID)) {
            return this.server();
        }
        return this.cache.get(uuid, id -> {
            MinecraftServer server = FabricImpactorBootstrap.instance().server().get();
            class_3324 players = server.method_3760();
            class_3222 player = players.method_14602(id);
            class_3312 cache = server.method_3793();
            Optional profile = cache.method_14512(uuid);
            if (player != null || profile.isPresent()) {
                return new FabricPlatformPlayer((UUID)id);
            }
            for (class_3218 level : FabricImpactorBootstrap.instance().server().get().method_3738()) {
                class_1297 entity = level.method_14190(id);
                if (entity == null) continue;
                FabricPlatformSource source2 = new FabricPlatformSource((UUID)id, SourceType.ENTITY);
                source2.offer(MetadataKeys.WORLD, () -> {
                    class_5321 key = level.method_27983();
                    return Key.key((String)key.method_29177().method_12836(), (String)key.method_29177().method_12832());
                });
                source2.offer(GameMetadataKeys.ENTITY, () -> entity);
                source2.offer(MetadataKeys.POSITION, () -> {
                    class_243 vec3 = entity.method_19538();
                    return new Vector3d(vec3.field_1352, vec3.field_1351, vec3.field_1350);
                });
                source2.offer(MetadataKeys.ROTATION, () -> {
                    class_241 vec2 = entity.method_5802();
                    return new Vector2d(vec2.field_1343, vec2.field_1342);
                });
                return source2;
            }
            throw new IllegalArgumentException("Could not locate a valid entity with this ID");
        });
    }

    @Override
    public PlatformPlayer player(UUID uuid) {
        return (PlatformPlayer)this.cache.get(uuid, FabricPlatformPlayer::new);
    }
}

