/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.platform.sources;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.items.extensions.BookStack;
import net.impactdev.impactor.api.items.platform.ItemTransaction;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.platform.sources.SourceType;
import net.impactdev.impactor.api.platform.sources.metadata.MetadataKeys;
import net.impactdev.impactor.core.platform.sources.ImpactorPlatformSource;
import net.impactdev.impactor.minecraft.api.items.ItemStackTranslator;
import net.impactdev.impactor.minecraft.api.key.ResourceKeyTranslator;
import net.impactdev.impactor.minecraft.api.text.AdventureTranslator;
import net.impactdev.impactor.minecraft.items.transactions.ImpactorItemTransaction;
import net.impactdev.impactor.minecraft.platform.GamePlatform;
import net.impactdev.impactor.minecraft.utility.RandomProvider;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2d;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector3d;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.pointer.Pointer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2770;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3312;
import net.minecraft.class_3895;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class ImpactorPlatformPlayer
extends ImpactorPlatformSource
implements PlatformPlayer {
    public static final Pointer<class_3222> PLAYER_FALLBACK = Pointer.pointer(class_3222.class, (Key)Key.key((String)"impactor", (String)"player-fallback"));

    public ImpactorPlatformPlayer(UUID uuid) {
        super(uuid, SourceType.PLAYER);
        this.offer(MetadataKeys.DISPLAY_NAME, () -> this.asMinecraftPlayer().map(class_1297::method_5797).map(AdventureTranslator::fromNative).orElse((Component)Component.text((String)"Unknown")));
        this.offer(MetadataKeys.POSITION, () -> this.asMinecraftPlayer().map(class_1297::method_19538).map(vec3 -> new Vector3d(vec3.field_1352, vec3.field_1351, vec3.field_1350)).orElse(Vector3d.ZERO));
        this.offer(MetadataKeys.ROTATION, () -> this.asMinecraftPlayer().map(class_1297::method_5802).map(vec2 -> new Vector2d(vec2.field_1343, vec2.field_1342)).orElse(Vector2d.ZERO));
        this.offer(MetadataKeys.PERMISSION_LEVEL, () -> this.asMinecraftPlayer().map(player -> {
            MinecraftServer server = ((GamePlatform)Impactor.instance().platform()).server();
            if (server.method_3760().method_14569(player.method_7334())) {
                return 4;
            }
            return 0;
        }).orElse(4));
    }

    public abstract Optional<class_3222> asMinecraftPlayer();

    private Optional<GameProfile> profile() {
        class_3312 cache = ((GamePlatform)Impactor.instance().platform()).server().method_3793();
        return cache.method_14512(this.uuid());
    }

    @Override
    public Component name() {
        return this.asMinecraftPlayer().map(class_1657::method_5477).map(AdventureTranslator::fromNative).orElseGet(() -> (Component)this.profile().map(GameProfile::getName).map(Component::text).orElse(Component.text((String)"Unknown")));
    }

    @Override
    public ItemTransaction offer(ImpactorItemStack stack) {
        return this.asMinecraftPlayer().map(player -> {
            class_1799 minecraft = Impactor.instance().services().provide(ItemStackTranslator.class).translate(stack);
            boolean result = player.method_7270(minecraft);
            return new ImpactorItemTransaction(stack, minecraft.method_7947(), result, null);
        }).orElse(null);
    }

    @Override
    public ItemTransaction take(ImpactorItemStack stack) {
        return null;
    }

    public void openBook(@NotNull Book book) {
        this.asMinecraftPlayer().ifPresent(target -> {
            class_3244 connection = target.field_13987;
            class_1661 inventory = target.method_31548();
            int slot = inventory.field_7547.size() + inventory.field_7545;
            BookStack item = (BookStack)ImpactorItemStack.book().title(GlobalTranslator.render((Component)book.title(), (Locale)this.locale())).author(LegacyComponentSerializer.legacyAmpersand().serialize(GlobalTranslator.render((Component)book.author(), (Locale)this.locale()))).pages(Lists.transform((List)book.pages(), page -> GlobalTranslator.render((Component)page, (Locale)this.locale()))).build();
            ItemStackTranslator translator = Impactor.instance().services().provide(ItemStackTranslator.class);
            class_1799 vanilla = translator.translate(item);
            connection.method_14364((class_2596)new class_2653(0, target.field_7512.method_37421(), slot, vanilla));
            connection.method_14364((class_2596)new class_3895(class_1268.field_5808));
            connection.method_14364((class_2596)new class_2653(0, target.field_7512.method_37421(), slot, inventory.method_7391()));
        });
    }

    public void sendMessage(@NotNull Identity source2, @NotNull Component message, @NotNull MessageType type) {
        Component translated = GlobalTranslator.render((Component)message, (Locale)this.locale());
        class_2561 vanilla = AdventureTranslator.toNative(translated);
        this.asMinecraftPlayer().ifPresent(target -> target.method_43496(vanilla));
    }

    public void sendActionBar(@NotNull Component message) {
        this.asMinecraftPlayer().ifPresent(target -> {
            class_5894 packet = new class_5894(this.toVanillaComponent(message));
            target.field_13987.method_14364((class_2596)packet);
        });
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        this.asMinecraftPlayer().ifPresent(target -> {
            if (part == TitlePart.TIMES) {
                Title.Times times = (Title.Times)value;
                target.field_13987.method_14364((class_2596)new class_5905((int)(times.fadeIn().toMillis() / 50L), (int)(times.stay().toMillis() / 50L), (int)(times.fadeOut().toMillis() / 50L)));
            } else if (part == TitlePart.TITLE) {
                target.field_13987.method_14364((class_2596)new class_5904(AdventureTranslator.toNative((Component)value)));
            } else {
                target.field_13987.method_14364((class_2596)new class_5903(AdventureTranslator.toNative((Component)value)));
            }
        });
    }

    public void playSound(@NotNull Sound sound) {
        this.asMinecraftPlayer().ifPresent(target -> this.playSound(sound, target.method_23317(), target.method_23318(), target.method_23321()));
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.asMinecraftPlayer().ifPresent(target -> {
            Optional<class_6880.class_6883> reference = class_7923.field_41172.method_40270().filter(event -> event.method_40226(ResourceKeyTranslator.asResourceLocation(sound.name()))).findFirst();
            reference.ifPresent(soundEventReference -> target.field_13987.method_14364((class_2596)new class_2767((class_6880)soundEventReference, AdventureTranslator.asVanilla(sound.source()), x, y, z, sound.volume(), sound.pitch(), RandomProvider.nextLong())));
        });
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        this.asMinecraftPlayer().ifPresent(target -> {
            Optional<class_6880.class_6883> reference = class_7923.field_41172.method_40270().filter(event -> event.method_40226(ResourceKeyTranslator.asResourceLocation(sound.name()))).findFirst();
            if (reference.isPresent()) {
                class_3222 tracked;
                if (emitter == Sound.Emitter.self()) {
                    tracked = target;
                } else if (emitter instanceof class_1297) {
                    tracked = (class_1297)emitter;
                } else {
                    throw new IllegalArgumentException("Specified emitter was not valid: '" + emitter.getClass() + "'");
                }
                target.field_13987.method_14364((class_2596)new class_2765((class_6880)reference.get(), AdventureTranslator.asVanilla(sound.source()), (class_1297)tracked, sound.volume(), sound.pitch(), RandomProvider.nextLong()));
            }
        });
    }

    public void stopSound(@NotNull SoundStop stop) {
        this.asMinecraftPlayer().ifPresent(target -> target.field_13987.method_14364((class_2596)new class_2770(ResourceKeyTranslator.asResourceLocationNullable(stop.sound()), AdventureTranslator.asVanillaNullable(stop.source()))));
    }

    private class_2561 toVanillaComponent(@NotNull Component message) {
        return AdventureTranslator.toNative(GlobalTranslator.render((Component)message, (Locale)this.locale()));
    }
}

