/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.plugin;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.function.Function;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.commands.CommandSource;
import net.impactdev.impactor.api.commands.events.RegisterBrigadierMappingsEvent;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.scheduler.v2.Schedulers;
import net.impactdev.impactor.core.commands.parsers.CurrencyParser;
import net.impactdev.impactor.core.commands.parsers.PlatformSourceParser;
import net.impactdev.impactor.core.modules.ModuleInitializer;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.plugin.ImpactorBootstrapper;
import net.impactdev.impactor.minecraft.items.ItemsModule;
import net.impactdev.impactor.minecraft.platform.GamePlatform;
import net.impactdev.impactor.minecraft.scheduler.SyncScheduler;
import net.impactdev.impactor.minecraft.scoreboard.ScoreboardModule;
import net.impactdev.impactor.minecraft.ui.UIModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import org.incendo.cloud.brigadier.argument.BrigadierMapping;
import org.incendo.cloud.brigadier.argument.BrigadierMappings;
import org.incendo.cloud.parser.ArgumentParser;

public abstract class GameImpactorPlugin
extends BaseImpactorPlugin {
    public GameImpactorPlugin(ImpactorBootstrapper bootstrapper) {
        super(bootstrapper);
    }

    @Override
    protected ModuleInitializer registerModules() {
        return super.registerModules().with(ItemsModule.class).with(ScoreboardModule.class).with(UIModule.class);
    }

    @Override
    public void construct() {
        Impactor.instance().events().subscribe(RegisterBrigadierMappingsEvent.class, event -> {
            BrigadierMappings<CommandSource, ?> mappings = event.mappings();
            BrigadierMapping<?, CurrencyParser, class_2168> currency = this.createMapping(parser -> class_2232.method_9441());
            BrigadierMapping<?, PlatformSourceParser, class_2168> sources = this.createMapping(parser -> class_2186.method_9309());
            mappings.registerMapping(PlatformSourceParser.class, sources);
            mappings.registerMapping(CurrencyParser.class, currency);
        });
        super.construct();
    }

    @Override
    public void starting() {
        ((SyncScheduler)Schedulers.require(Scheduler.SYNCHRONOUS)).initialize(this.platform().server());
    }

    @Override
    protected void setupSchedulers() {
        super.setupSchedulers();
        Schedulers.register(Scheduler.SYNCHRONOUS, new SyncScheduler(this.platform()));
    }

    private GamePlatform platform() {
        return (GamePlatform)Impactor.instance().platform();
    }

    private <T, K extends ArgumentParser<CommandSource, T>> BrigadierMapping<?, K, class_2168> createMapping(Function<K, ? extends ArgumentType<?>> adapter) {
        return BrigadierMapping.builder().cloudSuggestions().to(adapter).build();
    }
}

