/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scheduler;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.api.scheduler.SchedulerTask;
import net.impactdev.impactor.api.scheduler.Ticks;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.minecraft.platform.GamePlatform;
import net.impactdev.impactor.minecraft.scheduler.SynchronousTask;
import net.kyori.adventure.key.Key;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class SyncScheduler
implements Scheduler {
    private final Map<UUID, SynchronousTask> tasks = Maps.newConcurrentMap();
    private final Executor sync = r -> platform.server().method_19537(r);

    public SyncScheduler(GamePlatform platform) {
    }

    public void initialize(MinecraftServer server) {
        server.method_3742(this::tick);
    }

    @Override
    public Key key() {
        return Scheduler.SYNCHRONOUS;
    }

    @Override
    public Executor executor() {
        return this.sync;
    }

    @Override
    public void publish(@NotNull Runnable runnable2) {
        this.sync.execute(runnable2);
    }

    @Override
    public SchedulerTask delayed(@NotNull Runnable action, @NotNull Ticks ticks) {
        SynchronousTask task = new SynchronousTask(action, ticks, Ticks.zero());
        this.tasks.put(task.uuid(), task);
        return task::cancel;
    }

    @Override
    public SchedulerTask delayed(@NotNull Runnable action, long delay, @NotNull TimeUnit unit) {
        return this.delayed(action, Ticks.ofWallClockTime(delay, unit.toChronoUnit()));
    }

    @Override
    public SchedulerTask repeating(@NotNull Runnable action, @NotNull Ticks ticks) {
        SynchronousTask task = new SynchronousTask(action, Ticks.zero(), ticks);
        this.tasks.put(task.uuid(), task);
        return task::cancel;
    }

    @Override
    public SchedulerTask repeating(@NotNull Runnable action, long interval, @NotNull TimeUnit unit) {
        return this.repeating(action, Ticks.ofWallClockTime(interval, unit.toChronoUnit()));
    }

    @Override
    public SchedulerTask delayedAndRepeating(@NotNull Runnable action, @NotNull Ticks delay, @NotNull Ticks interval) {
        SynchronousTask task = new SynchronousTask(action, delay, interval);
        this.tasks.put(task.uuid(), task);
        return task::cancel;
    }

    @Override
    public SchedulerTask delayedAndRepeating(@NotNull Runnable action, long delay, long interval, @NotNull TimeUnit unit) {
        return this.delayedAndRepeating(action, Ticks.ofWallClockTime(delay, unit.toChronoUnit()), Ticks.ofWallClockTime(interval, unit.toChronoUnit()));
    }

    @Override
    public void shutdown() {
        this.tasks.forEach((key, task) -> task.cancel());
    }

    private void tick() {
        this.tasks.forEach((key, task) -> {
            task.tick();
            if (task.cancelled()) {
                this.tasks.remove(key);
            }
        });
    }
}

