/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scheduler;

import java.util.UUID;
import net.impactdev.impactor.api.scheduler.Ticks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SynchronousTask {
    private final UUID uuid = UUID.randomUUID();
    private final Runnable action;
    private final Ticks delay;
    private final Ticks interval;
    private boolean delayed;
    private long tick;
    private boolean cancelled;

    public SynchronousTask(@NotNull Runnable action, @Nullable Ticks delay, @Nullable Ticks interval) {
        this.action = action;
        this.delay = delay;
        this.interval = interval;
        this.delayed = this.delay != null && this.delay.ticks() > 0L;
    }

    public void tick() {
        ++this.tick;
        if (this.delayed) {
            if (this.tick >= this.delay.ticks()) {
                this.delayed = false;
                this.tick = 0L;
                this.action.run();
            }
        } else if (this.interval != null && this.interval.ticks() > 0L && this.tick >= this.interval.ticks()) {
            this.tick = 0L;
            this.action.run();
        }
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }
}

