/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.assigned;

import java.util.List;
import java.util.Optional;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.scoreboards.AssignedScoreboard;
import net.impactdev.impactor.api.scoreboards.Scoreboard;
import net.impactdev.impactor.api.scoreboards.ScoreboardRenderer;
import net.impactdev.impactor.api.scoreboards.display.Display;
import net.impactdev.impactor.api.scoreboards.lines.ScoreboardLine;
import net.impactdev.impactor.api.scoreboards.objectives.Objective;
import net.impactdev.impactor.core.utility.pointers.AbstractPointerCapable;
import net.impactdev.impactor.minecraft.scoreboard.display.lines.ImpactorScoreboardLine;
import net.impactdev.impactor.minecraft.scoreboard.display.objectives.ImpactorObjective;

public final class AssignedScoreboardImpl
extends AbstractPointerCapable
implements AssignedScoreboard {
    private final Scoreboard config;
    private final PlatformPlayer viewer;
    private final ScoreboardRenderer renderer;
    private final Objective.Displayed objective;
    private final List<ScoreboardLine.Displayed> lines;

    public AssignedScoreboardImpl(Scoreboard config, PlatformPlayer viewer) {
        this.config = config;
        this.viewer = viewer;
        this.renderer = config.renderer();
        this.objective = this.translate(config.objective(), ImpactorObjective.class).create(this);
        this.lines = config.lines().stream().map(input -> this.translate(input, ImpactorScoreboardLine.class).create(this)).toList();
    }

    @Override
    public Scoreboard configuration() {
        return this.config;
    }

    @Override
    public PlatformPlayer viewer() {
        return this.viewer;
    }

    @Override
    public Objective.Displayed objective() {
        return this.objective;
    }

    @Override
    public List<ScoreboardLine.Displayed> lines() {
        return this.lines;
    }

    @Override
    public void open() {
        this.renderer.show(this);
        Optional.ofNullable(this.objective.updater()).ifPresent(updater -> updater.start(this.objective));
        this.lines().forEach(line -> Optional.ofNullable(line.updater()).ifPresent(updater -> updater.start((Display)line)));
    }

    @Override
    public void hide() {
        Optional.ofNullable(this.objective.updater()).ifPresent(updater -> updater.stop(this.objective));
        this.lines().forEach(line -> Optional.ofNullable(line.updater()).ifPresent(updater -> updater.stop((Display)line)));
        this.renderer.hide(this);
    }

    @Override
    public void destroy() {
        this.hide();
    }

    private <I, T extends I> T translate(I input, Class<T> target) {
        return target.cast(input);
    }
}

