/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.display.objectives;

import net.impactdev.impactor.api.scoreboards.AssignedScoreboard;
import net.impactdev.impactor.api.scoreboards.display.text.ScoreboardComponent;
import net.impactdev.impactor.api.scoreboards.objectives.Objective;
import net.impactdev.impactor.api.scoreboards.score.ScoreFormatter;
import net.impactdev.impactor.api.scoreboards.updaters.UpdaterConfiguration;
import net.impactdev.impactor.minecraft.scoreboard.display.objectives.DisplayedObjective;
import org.jetbrains.annotations.Nullable;

public final class ImpactorObjective
implements Objective {
    private final ScoreboardComponent text;
    private final ScoreFormatter formatter;
    private final UpdaterConfiguration<?> updater;

    private ImpactorObjective(ImpactorObjectiveBuilder builder) {
        this.text = builder.text;
        this.formatter = builder.formatter;
        this.updater = builder.updater;
    }

    public DisplayedObjective create(AssignedScoreboard scoreboard) {
        return new DisplayedObjective(scoreboard, this);
    }

    @Override
    public ScoreboardComponent text() {
        return this.text;
    }

    @Override
    @Nullable
    public ScoreFormatter formatter() {
        return this.formatter;
    }

    @Override
    public ScoreboardComponent component() {
        return this.text;
    }

    @Override
    @Nullable
    public UpdaterConfiguration<?> updater() {
        return this.updater;
    }

    public static final class ImpactorObjectiveBuilder
    implements Objective.ObjectiveBuilder {
        private ScoreboardComponent text;
        private ScoreFormatter formatter;
        private UpdaterConfiguration<?> updater;

        @Override
        public Objective.ObjectiveBuilder text(ScoreboardComponent component) {
            this.text = component;
            return this;
        }

        @Override
        public Objective.ObjectiveBuilder formatter(ScoreFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public Objective.ObjectiveBuilder updater(UpdaterConfiguration<?> config) {
            this.updater = config;
            return this;
        }

        @Override
        public Objective build() {
            return new ImpactorObjective(this);
        }
    }
}

