/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import io.leangen.geantyref.TypeToken;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.processors.ClickProcessor;
import net.impactdev.impactor.api.utility.Context;
import org.jetbrains.annotations.NotNull;

public class ImpactorIcon
implements Icon {
    private final Context context;
    private final Supplier<ImpactorItemStack> provider;
    private final Set<ClickProcessor> processors;
    private final boolean refreshable;

    private ImpactorIcon(ImpactorIconBuilder builder) {
        this.context = builder.context;
        this.provider = builder.provider;
        this.processors = builder.processors;
        this.refreshable = builder.refreshable;
    }

    @Override
    @NotNull
    public Supplier<ImpactorItemStack> display() {
        return this.provider;
    }

    @Override
    @NotNull
    public Context context() {
        return this.context;
    }

    @Override
    @NotNull
    public Set<ClickProcessor> listeners() {
        return ImmutableSet.copyOf(this.processors);
    }

    @Override
    public Icon listener(ClickProcessor processor) {
        this.processors.add(processor);
        return this;
    }

    @Override
    public boolean refreshable() {
        return this.refreshable;
    }

    public static class ImpactorIconBuilder
    implements Icon.IconBuilder {
        private final Context context = Context.empty();
        private Supplier<ImpactorItemStack> provider;
        private final Set<ClickProcessor> processors = new LinkedHashSet<ClickProcessor>();
        private boolean refreshable = true;

        @Override
        public Icon.IconBuilder display(Supplier<ImpactorItemStack> display) {
            this.provider = display;
            return this;
        }

        @Override
        public Icon.IconBuilder listener(ClickProcessor processor) {
            this.processors.add(processor);
            return this;
        }

        @Override
        public <T> Icon.IconBuilder append(TypeToken<T> key, T value) {
            this.context.append(key, value);
            return this;
        }

        @Override
        public Icon.IconBuilder constant() {
            this.refreshable = false;
            return this;
        }

        @Override
        public Icon.IconBuilder from(Icon parent) {
            return this;
        }

        @Override
        public Icon build() {
            Preconditions.checkNotNull(this.provider, (Object)"Display provider was null");
            this.provider = this.refreshable ? this.provider : Suppliers.memoize(this.provider::get);
            return new ImpactorIcon(this);
        }
    }
}

