/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.Layout;

public abstract class ImpactorLayout
implements Layout {
    private final Map<Integer, Icon> slots;

    protected ImpactorLayout(Map<Integer, Icon> slots) {
        this.slots = slots;
    }

    @Override
    public ImmutableMap<Integer, Icon> elements() {
        return ImmutableMap.copyOf(this.slots);
    }

    @Override
    public Optional<Icon> icon(int slot) {
        return Optional.ofNullable(this.slots.get(slot));
    }

    public static abstract class IconHolder {
        protected Map<Integer, Icon> icons = Maps.newHashMap();

        public Map<Integer, Icon> icons() {
            return this.icons;
        }

        protected void set(int slot, Icon icon) {
            this.icons.put(slot, icon);
        }
    }
}

