/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.layouts;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.Layout;
import net.impactdev.impactor.api.ui.containers.layouts.ChestLayout;
import net.impactdev.impactor.minecraft.ui.containers.ImpactorLayout;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2i;

public class ImpactorChestLayout
extends ImpactorLayout
implements ChestLayout {
    private final Vector2i dimensions;

    protected ImpactorChestLayout(ImpactorChestLayoutBuilder builder) {
        super(builder.icons());
        this.dimensions = Vector2i.from(9, builder.rows);
    }

    @Override
    public Vector2i dimensions() {
        return this.dimensions;
    }

    public static class ImpactorChestLayoutBuilder
    extends ImpactorLayout.IconHolder
    implements ChestLayout.ChestLayoutBuilder {
        private int rows = 6;

        @Override
        public ChestLayout.ChestLayoutBuilder size(int rows) {
            this.rows = rows;
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder slot(Icon icon, int slot) {
            this.icons.put(slot, icon);
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder fill(Icon icon) {
            for (int i = 1; i < 9 * this.rows; ++i) {
                if (this.icons.containsKey(i)) continue;
                this.slot(icon, i);
            }
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder border(Icon icon) {
            this.column(icon, 1);
            this.column(icon, 9);
            this.row(icon, 1);
            this.row(icon, this.rows);
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder row(Icon icon, int row) {
            Preconditions.checkArgument((row >= 1 && row <= 6 ? 1 : 0) != 0, (Object)"Row outside boundaries");
            int start = 9 * (row - 1);
            for (int i = 0; i < 9; ++i) {
                this.slot(icon, start + i);
            }
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder column(Icon icon, int column) {
            Preconditions.checkArgument((column >= 1 && column <= 9 ? 1 : 0) != 0, (Object)"Column outside boundaries");
            for (int i = column - 1; i < 9 * this.rows; i += 9) {
                this.slot(icon, i);
            }
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder center(Icon icon) {
            if (this.rows % 2 == 0) {
                this.slot(icon, this.rows * 9 / 2 - 5);
                this.slot(icon, this.rows * 9 / 2 + 4);
            } else {
                this.slot(icon, this.rows * 9 / 2);
            }
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder square(Icon icon, int center, int radius, boolean hollow) {
            Vector2i size = Vector2i.from(radius);
            Vector2i offsets = Vector2i.from(center % 9, center / 9).sub(size);
            return this.rectangle(icon, size, offsets, hollow);
        }

        @Override
        public ChestLayout.ChestLayoutBuilder rectangle(Icon icon, Vector2i size, Vector2i offset, boolean hollow) {
            int x;
            for (x = offset.x(); x < size.x() + offset.x(); ++x) {
                this.slot(icon, x + 9 * offset.y());
            }
            for (x = offset.x(); x < size.x() + offset.x(); ++x) {
                for (int y = offset.y() + 1; y < size.y() + offset.y() - 1; ++y) {
                    if (hollow && x != offset.x() && x != size.x() + offset.x()) continue;
                    this.slot(icon, x + 9 * y);
                }
            }
            for (x = offset.x(); x < size.x() + offset.x(); ++x) {
                this.slot(icon, x + 9 * (size.y() + offset.y() - 1));
            }
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder consume(Consumer<ChestLayout.ChestLayoutBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        @Override
        public ChestLayout.ChestLayoutBuilder from(Layout layout) {
            return this;
        }

        @Override
        public ChestLayout build() {
            return new ImpactorChestLayout(this);
        }
    }
}

