/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views.chests;

import net.impactdev.impactor.api.ui.containers.layouts.ChestLayout;
import net.impactdev.impactor.api.ui.containers.views.ChestView;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.minecraft.ui.containers.views.ImpactorView;
import net.impactdev.impactor.minecraft.ui.containers.views.builders.ImpactorBaseViewBuilder;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2i;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.checkerframework.common.value.qual.IntRange;

public abstract class ImpactorChestView
extends ImpactorView
implements ChestView {
    private final ChestLayout layout;

    protected ImpactorChestView(ImpactorChestViewBuilder builder) {
        super(builder.namespace, builder.title, builder.readonly, builder.click, builder.close);
        this.layout = builder.layout;
    }

    @Override
    public ChestLayout layout() {
        return this.layout;
    }

    @Override
    public @IntRange(from=1L, to=6L) int rows() {
        return this.layout().dimensions().y();
    }

    @Override
    public void refresh(Vector2i dimensions, Vector2i offsets) {
    }

    protected void writeException(Context context) {
        PrettyPrinter printer = new PrettyPrinter(80);
        printer.newline().add("Exception during Inventory Action").newline().hr();
        printer.add("Namespace: " + this.namespace);
        printer.add("Context:");
        printer.kv("Title", PlainTextComponentSerializer.plainText().serialize(this.title));
        printer.kv("Read Only", this.readonly);
        context.print(printer);
    }

    public static abstract class ImpactorChestViewBuilder
    extends ImpactorBaseViewBuilder<ChestView.ChestViewBuilder>
    implements ChestView.ChestViewBuilder {
        private ChestLayout layout;

        @Override
        public ChestView.ChestViewBuilder layout(ChestLayout layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public ChestView.ChestViewBuilder from(ChestView parent) {
            return (ChestView.ChestViewBuilder)((ChestView.ChestViewBuilder)((ChestView.ChestViewBuilder)((ChestView.ChestViewBuilder)((ChestView.ChestViewBuilder)this.provider(parent.namespace())).title(parent.title())).layout(parent.layout()).readonly(parent.readonly())).onClick(((ImpactorChestView)parent).click)).onClose(((ImpactorChestView)parent).close);
        }
    }
}

