/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.views.sectioned;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.views.pagination.Page;
import net.impactdev.impactor.api.ui.containers.views.pagination.rules.ContextRuleset;
import net.impactdev.impactor.api.ui.containers.views.pagination.sectioned.sections.Section;
import net.impactdev.impactor.api.ui.containers.views.pagination.updaters.PageUpdater;
import net.impactdev.impactor.api.utility.collections.lists.CircularLinkedList;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.PaginatedView;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.layers.PageManager;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.views.sectioned.ImpactorSectionedPagination;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.views.sectioned.builders.ImpactorSectionBuilder;
import net.impactdev.impactor.relocations.org.spongepowered.math.vector.Vector2i;

public class ImpactorSection
implements Section,
PaginatedView {
    private ImpactorSectionedPagination parent;
    private final Vector2i dimensions;
    private final Vector2i offsets;
    private final ContextRuleset ruleset;
    private final Set<PageUpdater> updaters;
    private final List<Icon> contents;
    private final PageManager manager;

    public ImpactorSection(ImpactorSectionBuilder builder) {
        this.contents = builder.contents;
        this.dimensions = builder.dimensions;
        this.offsets = builder.offsets;
        this.ruleset = Optional.ofNullable(builder.ruleset).orElse(ContextRuleset.create());
        this.updaters = builder.updaters;
        this.manager = new PageManager(this);
    }

    ImpactorSection with(ImpactorSectionedPagination parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public List<Icon> contents() {
        return this.contents;
    }

    @Override
    public Vector2i zone() {
        return this.dimensions;
    }

    @Override
    public Vector2i offsets() {
        return this.offsets;
    }

    @Override
    public ContextRuleset ruleset() {
        return this.ruleset;
    }

    @Override
    public CircularLinkedList<Page> pages() {
        return this.manager.pages();
    }

    @Override
    public int page() {
        return this.manager.page();
    }

    @Override
    public Set<PageUpdater> updaters() {
        return this.updaters;
    }

    @Override
    public void update() {
        this.manager.update();
    }

    @Override
    public void page(int target) {
        this.manager.page(target);
        Page current = this.pages().current();
        current.icons().forEach((slot, icon) -> this.parent.set((Icon)icon, (int)slot));
    }
}

