/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.linked;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.UIManager;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.ButtonAction;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.GooeyButton;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.linked.LinkType;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.page.LinkedPage;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class LinkedPageButton
extends GooeyButton {
    private LinkType linkType;

    protected LinkedPageButton(@Nonnull class_1799 display, @Nullable Consumer<ButtonAction> onClick, @Nonnull LinkType linkType) {
        super(display, onClick);
        this.linkType = linkType;
    }

    @Override
    public void onClick(@Nonnull ButtonAction action) {
        super.onClick(action);
        if (action.getPage() instanceof LinkedPage) {
            LinkedPage targetPage;
            LinkedPage linkedPage = (LinkedPage)action.getPage();
            LinkedPage linkedPage2 = targetPage = this.linkType == LinkType.Previous ? linkedPage.getPrevious() : linkedPage.getNext();
            if (targetPage != null) {
                UIManager.openUIForcefully(action.getPlayer(), targetPage);
            }
        }
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GooeyButton.Builder {
        private LinkType linkType;

        @Override
        public Builder display(@Nonnull class_1799 display) {
            super.display(display);
            return this;
        }

        @Override
        public Builder title(@Nullable String title) {
            super.title(title);
            return this;
        }

        @Override
        public Builder title(@Nullable class_2561 title) {
            super.title(title);
            return this;
        }

        @Override
        public Builder onClick(@Nullable Consumer<ButtonAction> behaviour) {
            super.onClick(behaviour);
            return this;
        }

        public Builder linkType(@Nonnull LinkType linkType) {
            this.linkType = linkType;
            return this;
        }

        @Override
        public LinkedPageButton build() {
            this.validate();
            return new LinkedPageButton(this.buildDisplay(), this.onClick, this.linkType);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.linkType == null) {
                throw new IllegalStateException("link type must be defined!");
            }
        }
    }
}

