/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.types;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.Button;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.Template;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.TemplateType;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;

public class BrewingStandTemplate
extends Template {
    protected BrewingStandTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.BREWING_STAND, slots);
    }

    public TemplateSlotDelegate getFuel() {
        return this.getSlot(0);
    }

    public TemplateSlotDelegate getBottle(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.getSlot(index + 1);
    }

    public TemplateSlotDelegate getIngredient() {
        return this.getSlot(4);
    }

    public BrewingStandTemplate fuel(@Nullable Button button) {
        this.getSlot(4).setButton(button);
        return this;
    }

    public BrewingStandTemplate ingredient(@Nullable Button button) {
        this.getSlot(3).setButton(button);
        return this;
    }

    public BrewingStandTemplate bottle(int index, @Nullable Button button) {
        if (index >= 0 && index < 3) {
            this.getSlot(index).setButton(button);
        }
        return this;
    }

    public BrewingStandTemplate bottles(@Nullable Button button) {
        for (int i = 0; i < 3; ++i) {
            this.bottle(i, button);
        }
        return this;
    }

    public BrewingStandTemplate bottlesFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        for (int i = 0; i < 3; ++i) {
            this.bottle(i, iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public BrewingStandTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public BrewingStandTemplate clone() {
        TemplateSlotDelegate[] clonedSlots = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            Button button = this.getSlot(i).getButton().orElse(null);
            clonedSlots[i] = new TemplateSlotDelegate(button, i);
        }
        return new BrewingStandTemplate(clonedSlots);
    }

    public static class Builder {
        private BrewingStandTemplate templateInstance = new BrewingStandTemplate(TemplateHelper.slotsOf(5));

        public Builder fuel(@Nullable Button button) {
            this.templateInstance.fuel(button);
            return this;
        }

        public Builder ingredient(@Nullable Button button) {
            this.templateInstance.ingredient(button);
            return this;
        }

        public Builder bottle(int index, @Nullable Button button) {
            this.templateInstance.bottle(index, button);
            return this;
        }

        public Builder bottles(@Nullable Button button) {
            this.templateInstance.bottles(button);
            return this;
        }

        public Builder bottlesFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.bottlesFromList(buttons);
            return this;
        }

        public BrewingStandTemplate build() {
            BrewingStandTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new BrewingStandTemplate(TemplateHelper.slotsOf(5));
            return templateToReturn;
        }
    }
}

