/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.types;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.Button;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.LineType;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.Template;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.TemplateType;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;

public class ChestTemplate
extends Template {
    protected static final int COLUMNS = 9;

    public ChestTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.CHEST, slots);
    }

    public int getRows() {
        return this.getSize() / 9;
    }

    public TemplateSlotDelegate getSlot(int row, int col) {
        return this.getSlot(row * 9 + col);
    }

    public ChestTemplate set(int index, @Nullable Button button) {
        this.getSlot(index).setButton(button);
        return this;
    }

    public ChestTemplate set(int row, int col, @Nullable Button button) {
        this.getSlot(row * 9 + col).setButton(button);
        return this;
    }

    public ChestTemplate row(int row, @Nullable Button button) {
        if (row < 0 || row >= this.getRows()) {
            return this;
        }
        for (int col = 0; col < 9; ++col) {
            this.set(row, col, button);
        }
        return this;
    }

    public ChestTemplate rowFromList(int row, @Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        if (row < 0 || row >= this.getRows()) {
            return this;
        }
        for (int col = 0; col < 9; ++col) {
            this.set(row, col, iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public ChestTemplate column(int col, @Nullable Button button) {
        if (col < 0 || col >= 9) {
            return this;
        }
        for (int row = 0; row < this.getRows(); ++row) {
            this.set(row, col, button);
        }
        return this;
    }

    public ChestTemplate columnFromList(int col, @Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        if (col < 0 || col >= 9) {
            return this;
        }
        for (int row = 0; row < this.getRows(); ++row) {
            this.set(row, col, iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public ChestTemplate line(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nullable Button button) {
        if (lineType == LineType.HORIZONTAL) {
            if (startRow < 0 || startRow > this.getRows()) {
                return this;
            }
            int endCol = startCol + length - 1;
            for (int col = Math.max(0, startCol); col <= Math.min(9, endCol); ++col) {
                this.set(startRow, col, button);
            }
        } else {
            if (startCol < 0 || startCol > 9) {
                return this;
            }
            int endRow = startRow + length - 1;
            for (int row = Math.max(0, startRow); row <= Math.min(this.getRows(), endRow); ++row) {
                this.set(row, startCol, button);
            }
        }
        return this;
    }

    public ChestTemplate lineFromList(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        if (lineType == LineType.HORIZONTAL) {
            if (startRow < 0 || startRow > this.getRows()) {
                return this;
            }
            int endCol = startCol + length - 1;
            for (int col = Math.max(0, startCol); col <= Math.min(9, endCol); ++col) {
                this.set(startRow, col, iterator2.hasNext() ? iterator2.next() : null);
            }
        } else {
            if (startCol < 0 || startCol > 9) {
                return this;
            }
            int endRow = startRow + length - 1;
            for (int row = Math.max(0, startRow); row <= Math.min(this.getRows(), endRow); ++row) {
                this.set(row, startCol, iterator2.hasNext() ? iterator2.next() : null);
            }
        }
        return this;
    }

    public ChestTemplate square(int startRow, int startCol, int size, @Nullable Button button) {
        this.rectangle(startRow, startCol, size, size, button);
        return this;
    }

    public ChestTemplate squareFromList(int startRow, int startCol, int size, @Nonnull List<Button> buttons) {
        this.rectangleFromList(startRow, startCol, size, size, buttons);
        return this;
    }

    public ChestTemplate rectangle(int startRow, int startCol, int length, int width, @Nullable Button button) {
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (int row = startRow; row < endRow; ++row) {
            for (int col = startCol; col < endCol; ++col) {
                this.set(row, col, button);
            }
        }
        return this;
    }

    public ChestTemplate rectangleFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (int row = startRow; row < endRow; ++row) {
            for (int col = startCol; col < endCol; ++col) {
                this.set(row, col, iterator2.hasNext() ? iterator2.next() : null);
            }
        }
        return this;
    }

    public ChestTemplate border(int startRow, int startCol, int length, int width, @Nullable Button button) {
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (int row = startRow; row < endRow; ++row) {
            this.set(row, startCol, button);
            this.set(row, endCol - 1, button);
        }
        for (int col = startCol; col < endCol; ++col) {
            this.set(startRow, col, button);
            this.set(endRow - 1, col, button);
        }
        return this;
    }

    public ChestTemplate borderFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
        int col;
        int row;
        Iterator<Button> iterator2 = buttons.iterator();
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (row = startRow; row < endRow; ++row) {
            this.set(row, startCol, iterator2.hasNext() ? iterator2.next() : null);
        }
        for (col = startCol; col < endCol; ++col) {
            this.set(endRow - 1, col, iterator2.hasNext() ? iterator2.next() : null);
        }
        for (row = startRow; row < endRow; ++row) {
            this.set(row, endCol - 1, iterator2.hasNext() ? iterator2.next() : null);
        }
        for (col = startCol; col < endCol; ++col) {
            this.set(startRow, col, iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public ChestTemplate checker(int startRow, int startCol, int length, int width, @Nullable Button button, @Nullable Button button2) {
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (int row = startRow; row < endRow; ++row) {
            for (int col = startCol; col < endCol; ++col) {
                if (row - col == 0 || (row - col) % 2 == 0) {
                    this.set(row, col, button);
                    continue;
                }
                this.set(row, col, button2);
            }
        }
        return this;
    }

    public ChestTemplate checkerFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons, @Nonnull List<Button> buttons2) {
        Iterator<Button> iterator1 = buttons.iterator();
        Iterator<Button> iterator2 = buttons2.iterator();
        startRow = Math.max(0, startRow);
        startCol = Math.max(0, startCol);
        int endRow = Math.min(this.getRows(), startRow + length);
        int endCol = Math.min(9, startCol + width);
        for (int row = startRow; row < endRow; ++row) {
            for (int col = startCol; col < endCol; ++col) {
                if (row - col == 0 || (row - col) % 2 == 0) {
                    this.set(row, col, iterator1.hasNext() ? iterator1.next() : null);
                    continue;
                }
                this.set(row, col, iterator2.hasNext() ? iterator2.next() : null);
            }
        }
        return this;
    }

    public ChestTemplate fill(@Nullable Button button) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.getSlot(i).getButton().isEmpty()) continue;
            this.getSlot(i).setButton(button);
        }
        return this;
    }

    public ChestTemplate fillFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.getSlot(i).getButton().isEmpty()) continue;
            this.getSlot(i).setButton(iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public ChestTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    public static Builder builder(int rows) {
        return new Builder(rows);
    }

    @Override
    public ChestTemplate clone() {
        TemplateSlotDelegate[] results = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            TemplateSlotDelegate button;
            results[i] = button = new TemplateSlotDelegate(this.getSlot(i).getButton().orElse(null), i);
        }
        return new ChestTemplate(results);
    }

    public static class Builder {
        private ChestTemplate templateInstance;
        protected int rows;

        public Builder(int rows) {
            this.rows = rows;
            this.templateInstance = new ChestTemplate(TemplateHelper.slotsOf(rows * 9));
        }

        public Builder set(int index, @Nullable Button button) {
            this.templateInstance.set(index, button);
            return this;
        }

        public Builder set(int row, int col, @Nullable Button button) {
            this.templateInstance.set(row, col, button);
            return this;
        }

        public Builder row(int row, @Nullable Button button) {
            this.templateInstance.row(row, button);
            return this;
        }

        public Builder rowFromList(int row, @Nonnull List<Button> buttons) {
            this.templateInstance.rowFromList(row, buttons);
            return this;
        }

        public Builder column(int col, @Nullable Button button) {
            this.templateInstance.column(col, button);
            return this;
        }

        public Builder columnFromList(int col, @Nonnull List<Button> buttons) {
            this.templateInstance.columnFromList(col, buttons);
            return this;
        }

        public Builder line(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nullable Button button) {
            this.templateInstance.line(lineType, startRow, startCol, length, button);
            return this;
        }

        public Builder lineFromList(@Nonnull LineType lineType, int startRow, int startCol, int length, @Nonnull List<Button> buttons) {
            this.templateInstance.lineFromList(lineType, startRow, startCol, length, buttons);
            return this;
        }

        public Builder square(int startRow, int startCol, int size, @Nullable Button button) {
            this.templateInstance.square(startRow, startCol, size, button);
            return this;
        }

        public Builder squareFromList(int startRow, int startCol, int size, @Nonnull List<Button> buttons) {
            this.templateInstance.squareFromList(startRow, startCol, size, buttons);
            return this;
        }

        public Builder rectangle(int startRow, int startCol, int length, int width, @Nullable Button button) {
            this.templateInstance.rectangle(startRow, startCol, length, width, button);
            return this;
        }

        public Builder rectangleFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
            this.templateInstance.rectangleFromList(startRow, startCol, length, width, buttons);
            return this;
        }

        public Builder border(int startRow, int startCol, int length, int width, @Nullable Button button) {
            this.templateInstance.border(startRow, startCol, length, width, button);
            return this;
        }

        public Builder borderFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons) {
            this.templateInstance.borderFromList(startRow, startCol, length, width, buttons);
            return this;
        }

        public Builder checker(int startRow, int startCol, int length, int width, @Nullable Button button, @Nullable Button button2) {
            this.templateInstance.checker(startRow, startCol, length, width, button, button2);
            return this;
        }

        public Builder checkerFromList(int startRow, int startCol, int length, int width, @Nonnull List<Button> buttons, @Nonnull List<Button> buttons2) {
            this.templateInstance.checkerFromList(startRow, startCol, length, width, buttons, buttons2);
            return this;
        }

        public Builder fill(@Nullable Button button) {
            this.templateInstance.fill(button);
            return this;
        }

        public Builder fillFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillFromList(buttons);
            return this;
        }

        public ChestTemplate build() {
            ChestTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new ChestTemplate(TemplateHelper.slotsOf(9 * this.rows));
            return templateToReturn;
        }
    }
}

