/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.types;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.button.Button;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.helpers.TemplateHelper;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.Template;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.TemplateType;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.template.slot.TemplateSlotDelegate;

public class HopperTemplate
extends Template {
    protected HopperTemplate(@Nonnull TemplateSlotDelegate[] slots) {
        super(TemplateType.HOPPER, slots);
    }

    public static Builder builder() {
        return new Builder();
    }

    public HopperTemplate set(int index, @Nullable Button button) {
        this.getSlot(index).setButton(button);
        return this;
    }

    public HopperTemplate fill(@Nullable Button button) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(button);
        }
        return this;
    }

    public HopperTemplate fillFromList(@Nonnull List<Button> buttons) {
        Iterator<Button> iterator2 = buttons.iterator();
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getSlot(i).getButton().isPresent()) continue;
            this.getSlot(i).setButton(iterator2.hasNext() ? iterator2.next() : null);
        }
        return this;
    }

    public HopperTemplate clear() {
        for (int slotIndex = 0; slotIndex < this.getSize(); ++slotIndex) {
            this.getSlot(slotIndex).setButton(null);
        }
        return this;
    }

    @Override
    public HopperTemplate clone() {
        TemplateSlotDelegate[] clonedSlots = new TemplateSlotDelegate[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            Button button = this.getSlot(i).getButton().orElse(null);
            clonedSlots[i] = new TemplateSlotDelegate(button, i);
        }
        return new HopperTemplate(clonedSlots);
    }

    public static class Builder {
        private HopperTemplate templateInstance = new HopperTemplate(TemplateHelper.slotsOf(5));

        public Builder set(int index, @Nullable Button button) {
            this.templateInstance.set(index, button);
            return this;
        }

        public Builder fill(@Nullable Button button) {
            this.templateInstance.fill(button);
            return this;
        }

        public Builder fillFromList(@Nonnull List<Button> buttons) {
            this.templateInstance.fillFromList(buttons);
            return this;
        }

        public HopperTemplate build() {
            HopperTemplate templateToReturn = this.templateInstance;
            this.templateInstance = new HopperTemplate(TemplateHelper.slotsOf(5));
            return templateToReturn;
        }
    }
}

