/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.fabric.implementation.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.impactdev.impactor.relocations.ca.landonjw.gooeylibs2.api.tasks.Task;
import net.minecraft.server.MinecraftServer;

public class FabricTask
implements Task {
    private static final FabricEndTickParent parent = new FabricEndTickParent();
    private final Consumer<Task> consumer;
    private final FabricEndTickChild event;
    private final long interval;
    private long currentIteration;
    private final long iterations;
    private long ticksRemaining;
    private boolean expired;

    FabricTask(Consumer<Task> consumer, long delay, long interval, long iterations) {
        this.consumer = consumer;
        this.interval = interval;
        this.iterations = iterations;
        if (delay > 0L) {
            this.ticksRemaining = delay;
        }
        parent.initialize();
        this.event = new FabricEndTickChild(this::onServerTick);
        parent.register(this.event);
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public void setExpired() {
        this.expired = true;
    }

    void tick() {
        if (!this.expired) {
            this.ticksRemaining = Math.max(0L, --this.ticksRemaining);
            if (this.ticksRemaining == 0L) {
                this.consumer.accept(this);
                ++this.currentIteration;
                if (this.interval > 0L && (this.currentIteration < this.iterations || this.iterations == -1L)) {
                    this.ticksRemaining = this.interval;
                } else {
                    this.expired = true;
                }
            }
        }
    }

    public void onServerTick(MinecraftServer server) {
        this.tick();
        if (this.isExpired()) {
            parent.unregister(this.event);
        }
    }

    public static class FabricEndTickParent
    implements ServerTickEvents.EndTick {
        private final Collection<ServerTickEvents.EndTick> children = new HashSet<ServerTickEvents.EndTick>();
        private boolean initialized;

        public void initialize() {
            if (!this.initialized) {
                ServerTickEvents.END_SERVER_TICK.register((Object)this);
                this.initialized = true;
            }
        }

        public void register(FabricEndTickChild child) {
            this.children.add(child);
        }

        private void unregister(FabricEndTickChild child) {
            this.children.remove(child);
        }

        public void onEndTick(MinecraftServer server) {
            new ArrayList<ServerTickEvents.EndTick>(this.children).forEach(child -> child.onEndTick(server));
        }
    }

    public static class FabricEndTickChild
    implements ServerTickEvents.EndTick {
        private final UUID identifier = UUID.randomUUID();
        private final ServerTickEvents.EndTick delegate;

        public FabricEndTickChild(ServerTickEvents.EndTick delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FabricEndTickChild that = (FabricEndTickChild)o;
            return Objects.equals(this.identifier, that.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        public void onEndTick(MinecraftServer server) {
            this.delegate.onEndTick(server);
        }
    }

    public static class FabricTaskBuilder
    implements Task.TaskBuilder {
        private Consumer<Task> consumer;
        private long delay;
        private long interval;
        private long iterations = 1L;

        @Override
        public Task.TaskBuilder execute(@Nonnull Runnable runnable2) {
            this.consumer = task -> runnable2.run();
            return this;
        }

        @Override
        public Task.TaskBuilder execute(@Nonnull Consumer<Task> consumer) {
            this.consumer = consumer;
            return this;
        }

        @Override
        public Task.TaskBuilder delay(long delay) {
            if (delay < 0L) {
                throw new IllegalArgumentException("delay must not be below 0");
            }
            this.delay = delay;
            return this;
        }

        @Override
        public Task.TaskBuilder interval(long interval) {
            if (interval < 0L) {
                throw new IllegalArgumentException("interval must not be below 0");
            }
            this.interval = interval;
            return this;
        }

        @Override
        public Task.TaskBuilder iterations(long iterations) {
            if (iterations < -1L) {
                throw new IllegalArgumentException("iterations must not be below -1");
            }
            this.iterations = iterations;
            return this;
        }

        @Override
        public Task.TaskBuilder infinite() {
            return this.iterations(-1L);
        }

        @Override
        public FabricTask build() {
            if (this.consumer == null) {
                throw new IllegalStateException("consumer must be set");
            }
            return new FabricTask(this.consumer, this.delay, this.interval, this.iterations);
        }
    }
}

