/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache;

import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Node;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Pacer;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.SILS;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Scheduler;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Ticker;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.WriteOrderDeque;
import org.checkerframework.checker.nullness.qual.Nullable;

class SILSW<K, V>
extends SILS<K, V> {
    static final LocalCacheFactory FACTORY = SILSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SILSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

