/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.impactdev.impactor.relocations.com.mongodb.DBCollection;
import net.impactdev.impactor.relocations.com.mongodb.DBDecoder;
import net.impactdev.impactor.relocations.com.mongodb.DBObject;
import net.impactdev.impactor.relocations.com.mongodb.MongoInternalException;
import net.impactdev.impactor.relocations.com.mongodb.connection.BufferProvider;
import net.impactdev.impactor.relocations.com.mongodb.connection.ByteBufferBsonOutput;
import net.impactdev.impactor.relocations.org.bson.BsonBinaryWriter;
import net.impactdev.impactor.relocations.org.bson.BsonReader;
import net.impactdev.impactor.relocations.org.bson.codecs.Decoder;
import net.impactdev.impactor.relocations.org.bson.codecs.DecoderContext;

class DBDecoderAdapter
implements Decoder<DBObject> {
    private final DBDecoder decoder;
    private final DBCollection collection;
    private final BufferProvider bufferProvider;

    DBDecoderAdapter(DBDecoder decoder, DBCollection collection, BufferProvider bufferProvider) {
        this.decoder = decoder;
        this.collection = collection;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this.bufferProvider);
        BsonBinaryWriter binaryWriter = new BsonBinaryWriter(bsonOutput);
        try {
            binaryWriter.pipe(reader);
            BufferExposingByteArrayOutputStream byteArrayOutputStream = new BufferExposingByteArrayOutputStream(binaryWriter.getBsonOutput().getSize());
            bsonOutput.pipe(byteArrayOutputStream);
            DBObject dBObject = this.decoder.decode(byteArrayOutputStream.getInternalBytes(), this.collection);
            return dBObject;
        }
        catch (IOException e) {
            throw new MongoInternalException("An unlikely IOException thrown.", e);
        }
        finally {
            binaryWriter.close();
            bsonOutput.close();
        }
    }

    private static class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }
}

