/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import java.nio.ByteBuffer;
import net.impactdev.impactor.relocations.com.mongodb.DBEncoder;
import net.impactdev.impactor.relocations.com.mongodb.DBObject;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.org.bson.BsonBinaryReader;
import net.impactdev.impactor.relocations.org.bson.BsonWriter;
import net.impactdev.impactor.relocations.org.bson.ByteBufNIO;
import net.impactdev.impactor.relocations.org.bson.codecs.Encoder;
import net.impactdev.impactor.relocations.org.bson.codecs.EncoderContext;
import net.impactdev.impactor.relocations.org.bson.io.BasicOutputBuffer;
import net.impactdev.impactor.relocations.org.bson.io.ByteBufferBsonInput;

class DBEncoderAdapter
implements Encoder<DBObject> {
    private final DBEncoder encoder;

    DBEncoderAdapter(DBEncoder encoder) {
        this.encoder = Assertions.notNull("encoder", encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try {
            this.encoder.writeObject(buffer, document);
            BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(buffer.toByteArray()))));
            try {
                writer.pipe(reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            buffer.close();
        }
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }
}

