/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb;

import net.impactdev.impactor.relocations.com.mongodb.BasicDBObject;
import net.impactdev.impactor.relocations.com.mongodb.DBEncoder;
import net.impactdev.impactor.relocations.com.mongodb.DBEncoderFactory;
import net.impactdev.impactor.relocations.com.mongodb.DBRef;
import net.impactdev.impactor.relocations.org.bson.BSONObject;
import net.impactdev.impactor.relocations.org.bson.BasicBSONEncoder;
import net.impactdev.impactor.relocations.org.bson.io.OutputBuffer;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static final DBEncoderFactory FACTORY = new DBEncoderFactory(){

        @Override
        public DBEncoder create() {
            return new DefaultDBEncoder();
        }
    };

    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document) {
        this.set(outputBuffer);
        int x = this.putObject(document);
        this.done();
        return x;
    }

    @Override
    protected boolean putSpecial(String name, Object value) {
        if (value instanceof DBRef) {
            this.putDBRef(name, (DBRef)value);
            return true;
        }
        return false;
    }

    protected void putDBRef(String name, DBRef ref) {
        BasicDBObject dbRefDocument = new BasicDBObject("$ref", ref.getCollectionName()).append("$id", ref.getId());
        if (ref.getDatabaseName() != null) {
            dbRefDocument.put("$db", ref.getDatabaseName());
        }
        this.putObject(name, dbRefDocument);
    }

    public String toString() {
        return String.format("DBEncoder{class=%s}", this.getClass().getName());
    }
}

