/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.impactdev.impactor.relocations.com.mongodb.ClientSessionOptions;
import net.impactdev.impactor.relocations.com.mongodb.MongoClientException;
import net.impactdev.impactor.relocations.com.mongodb.MongoCredential;
import net.impactdev.impactor.relocations.com.mongodb.MongoException;
import net.impactdev.impactor.relocations.com.mongodb.MongoInternalException;
import net.impactdev.impactor.relocations.com.mongodb.MongoQueryException;
import net.impactdev.impactor.relocations.com.mongodb.MongoSocketException;
import net.impactdev.impactor.relocations.com.mongodb.MongoTimeoutException;
import net.impactdev.impactor.relocations.com.mongodb.ReadConcern;
import net.impactdev.impactor.relocations.com.mongodb.ReadPreference;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.TransactionOptions;
import net.impactdev.impactor.relocations.com.mongodb.WriteConcern;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.com.mongodb.binding.ClusterBinding;
import net.impactdev.impactor.relocations.com.mongodb.binding.ReadBinding;
import net.impactdev.impactor.relocations.com.mongodb.binding.ReadWriteBinding;
import net.impactdev.impactor.relocations.com.mongodb.binding.WriteBinding;
import net.impactdev.impactor.relocations.com.mongodb.client.ClientSession;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.ClientSessionBinding;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.ClientSessionImpl;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.Crypt;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.CryptBinding;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.OperationExecutor;
import net.impactdev.impactor.relocations.com.mongodb.connection.Cluster;
import net.impactdev.impactor.relocations.com.mongodb.connection.ClusterConnectionMode;
import net.impactdev.impactor.relocations.com.mongodb.connection.ClusterDescription;
import net.impactdev.impactor.relocations.com.mongodb.connection.ServerDescription;
import net.impactdev.impactor.relocations.com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import net.impactdev.impactor.relocations.com.mongodb.internal.session.ServerSessionPool;
import net.impactdev.impactor.relocations.com.mongodb.lang.Nullable;
import net.impactdev.impactor.relocations.com.mongodb.operation.ReadOperation;
import net.impactdev.impactor.relocations.com.mongodb.operation.WriteOperation;
import net.impactdev.impactor.relocations.com.mongodb.selector.ServerSelector;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecRegistry;

public class MongoClientDelegate {
    private final Cluster cluster;
    private final ServerSessionPool serverSessionPool;
    private final List<MongoCredential> credentialList;
    private final Object originator;
    private final OperationExecutor operationExecutor;
    private final Crypt crypt;
    private final CodecRegistry codecRegistry;
    private final AtomicBoolean closed;

    public MongoClientDelegate(Cluster cluster, CodecRegistry codecRegistry, List<MongoCredential> credentialList, Object originator, @Nullable Crypt crypt) {
        this(cluster, codecRegistry, credentialList, originator, null, crypt);
    }

    MongoClientDelegate(Cluster cluster, CodecRegistry codecRegistry, List<MongoCredential> credentialList, Object originator, @Nullable OperationExecutor operationExecutor, @Nullable Crypt crypt) {
        this.cluster = cluster;
        this.codecRegistry = codecRegistry;
        this.serverSessionPool = new ServerSessionPool(cluster);
        this.credentialList = credentialList;
        this.originator = originator;
        this.operationExecutor = operationExecutor == null ? new DelegateOperationExecutor() : operationExecutor;
        this.crypt = crypt;
        this.closed = new AtomicBoolean();
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Nullable
    public ClientSession createClientSession(ClientSessionOptions options, ReadConcern readConcern, WriteConcern writeConcern, ReadPreference readPreference) {
        Assertions.notNull("readConcern", readConcern);
        Assertions.notNull("writeConcern", writeConcern);
        Assertions.notNull("readPreference", readPreference);
        if (this.credentialList.size() > 1) {
            return null;
        }
        ClusterDescription connectedClusterDescription = this.getConnectedClusterDescription();
        if (connectedClusterDescription.getLogicalSessionTimeoutMinutes() == null) {
            return null;
        }
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder(options).defaultTransactionOptions(TransactionOptions.merge(options.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(readConcern).writeConcern(writeConcern).readPreference(readPreference).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.originator, mergedOptions, this);
    }

    public List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        for (ServerDescription cur : this.cluster.getDescription().getServerDescriptions()) {
            serverAddresses.add(cur.getAddress());
        }
        return serverAddresses;
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.crypt != null) {
                this.crypt.close();
            }
            this.serverSessionPool.close();
            this.cluster.close();
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    private ClusterDescription getConnectedClusterDescription() {
        ClusterDescription clusterDescription = this.cluster.getDescription();
        if (this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty()) {
            this.cluster.selectServer(new ServerSelector(){

                @Override
                public List<ServerDescription> select(ClusterDescription clusterDescription) {
                    return MongoClientDelegate.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                }
            });
            clusterDescription = this.cluster.getDescription();
        }
        return clusterDescription;
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return clusterDescription.getAnyPrimaryOrSecondary();
    }

    private class DelegateOperationExecutor
    implements OperationExecutor {
        private DelegateOperationExecutor() {
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern) {
            return this.execute(operation, readPreference, readConcern, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern) {
            return this.execute(operation, readConcern, null);
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
            ClientSession actualClientSession = this.getClientSession(session);
            ReadBinding binding = this.getReadBinding(readPreference, readConcern, actualClientSession, session == null && actualClientSession != null);
            try {
                if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                    throw new MongoClientException("Read preference in a transaction must be primary");
                }
                T t = operation.execute(binding);
                return t;
            }
            catch (MongoException e) {
                this.labelException(session, e);
                this.unpinServerAddressOnTransientTransactionError(session, e);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
            ClientSession actualClientSession = this.getClientSession(session);
            WriteBinding binding = this.getWriteBinding(readConcern, actualClientSession, session == null && actualClientSession != null);
            try {
                T t = operation.execute(binding);
                return t;
            }
            catch (MongoException e) {
                this.labelException(session, e);
                this.unpinServerAddressOnTransientTransactionError(session, e);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        WriteBinding getWriteBinding(ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(ReadPreference.primary(), readConcern, session, ownsSession);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(readPreference, readConcern, session, ownsSession);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            ClusterAwareReadWriteBinding readWriteBinding = new ClusterBinding(MongoClientDelegate.this.cluster, this.getReadPreferenceForBinding(readPreference, session), readConcern);
            if (MongoClientDelegate.this.crypt != null) {
                readWriteBinding = new CryptBinding(readWriteBinding, MongoClientDelegate.this.crypt);
            }
            if (session != null) {
                return new ClientSessionBinding(session, ownsSession, readWriteBinding);
            }
            return readWriteBinding;
        }

        private void labelException(@Nullable ClientSession session, MongoException e) {
            if (session != null && session.hasActiveTransaction() && (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoQueryException && e.getCode() == 91) && !e.hasErrorLabel("UnknownTransactionCommitResult")) {
                e.addLabel("TransientTransactionError");
            }
        }

        private void unpinServerAddressOnTransientTransactionError(@Nullable ClientSession session, MongoException e) {
            if (session != null && e.hasErrorLabel("TransientTransactionError")) {
                session.setPinnedServerAddress(null);
            }
        }

        private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
            if (session == null) {
                return readPreference;
            }
            if (session.hasActiveTransaction()) {
                ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
                if (readPreferenceForBinding == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
                }
                return readPreferenceForBinding;
            }
            return readPreference;
        }

        @Nullable
        ClientSession getClientSession(@Nullable ClientSession clientSessionFromOperation) {
            ClientSession session;
            if (clientSessionFromOperation != null) {
                Assertions.isTrue("ClientSession from same MongoClient", clientSessionFromOperation.getOriginator() == MongoClientDelegate.this.originator);
                session = clientSessionFromOperation;
            } else {
                session = MongoClientDelegate.this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, ReadPreference.primary());
            }
            return session;
        }
    }
}

