/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.internal.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.impactdev.impactor.relocations.com.mongodb.MongoInternalException;
import net.impactdev.impactor.relocations.org.bson.ByteBuf;
import net.impactdev.impactor.relocations.org.bson.io.BsonOutput;

abstract class Compressor {
    static final int BUFFER_SIZE = 256;

    Compressor() {
    }

    abstract String getName();

    abstract byte getId();

    void compress(List<ByteBuf> source2, BsonOutput target) {
        BufferExposingByteArrayOutputStream baos = new BufferExposingByteArrayOutputStream(1024);
        OutputStream outputStream2 = null;
        try {
            outputStream2 = this.getOutputStream(baos);
            byte[] scratch = new byte[256];
            for (ByteBuf cur : source2) {
                while (cur.hasRemaining()) {
                    int numBytes = Math.min(cur.remaining(), scratch.length);
                    cur.get(scratch, 0, numBytes);
                    outputStream2.write(scratch, 0, numBytes);
                }
            }
        }
        catch (IOException e) {
            throw new MongoInternalException("Unexpected IOException", e);
        }
        finally {
            try {
                if (outputStream2 != null) {
                    outputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
        target.writeBytes(baos.getInternalBytes(), 0, baos.size());
    }

    void uncompress(ByteBuf source2, ByteBuf target) {
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.getInputStream(new ByteBufInputStream(source2));
            byte[] scratch = new byte[256];
            int numBytes = inputStream2.read(scratch);
            while (numBytes != -1) {
                target.put(scratch, 0, numBytes);
                numBytes = inputStream2.read(scratch);
            }
        }
        catch (IOException e) {
            throw new MongoInternalException("Unexpected IOException", e);
        }
        finally {
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    OutputStream getOutputStream(OutputStream source2) throws IOException {
        throw new UnsupportedEncodingException();
    }

    InputStream getInputStream(InputStream source2) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static final class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }

    private static final class ByteBufInputStream
    extends InputStream {
        private final ByteBuf source;

        ByteBufInputStream(ByteBuf source2) {
            this.source = source2;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            if (!this.source.hasRemaining()) {
                return -1;
            }
            int bytesToRead = length > this.source.remaining() ? this.source.remaining() : length;
            this.source.get(bytes, offset, bytesToRead);
            return bytesToRead;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }
    }
}

