/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.internal.session;

import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.com.mongodb.session.ClientSession;
import net.impactdev.impactor.relocations.com.mongodb.session.SessionContext;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonTimestamp;

public abstract class ClientSessionContext
implements SessionContext {
    private ClientSession clientSession;

    public ClientSessionContext(ClientSession clientSession) {
        this.clientSession = Assertions.notNull("clientSession", clientSession);
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public boolean hasSession() {
        return true;
    }

    @Override
    public BsonDocument getSessionId() {
        return this.clientSession.getServerSession().getIdentifier();
    }

    @Override
    public boolean isCausallyConsistent() {
        return this.clientSession.isCausallyConsistent();
    }

    @Override
    public long getTransactionNumber() {
        return this.clientSession.getServerSession().getTransactionNumber();
    }

    @Override
    public long advanceTransactionNumber() {
        return this.clientSession.getServerSession().advanceTransactionNumber();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.clientSession.getOperationTime();
    }

    @Override
    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.clientSession.advanceOperationTime(operationTime);
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clientSession.getClusterTime();
    }

    @Override
    public void advanceClusterTime(BsonDocument clusterTime) {
        this.clientSession.advanceClusterTime(clusterTime);
    }

    @Override
    public void setRecoveryToken(BsonDocument recoveryToken) {
        this.clientSession.setRecoveryToken(recoveryToken);
    }

    @Override
    public void unpinServerAddress() {
        this.clientSession.setPinnedServerAddress(null);
    }

    @Override
    public void markSessionDirty() {
        this.clientSession.getServerSession().markDirty();
    }

    @Override
    public boolean isSessionMarkedDirty() {
        return this.clientSession.getServerSession().isMarkedDirty();
    }
}

