/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.management;

import java.util.concurrent.atomic.AtomicInteger;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.connection.ConnectionPoolSettings;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionAddedEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionCheckedInEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionCheckedOutEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionPoolListenerAdapter;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionPoolOpenedEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import net.impactdev.impactor.relocations.com.mongodb.event.ConnectionRemovedEvent;
import net.impactdev.impactor.relocations.com.mongodb.management.ConnectionPoolStatisticsMBean;

final class ConnectionPoolStatistics
extends ConnectionPoolListenerAdapter
implements ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();
    private final AtomicInteger waitQueueSize = new AtomicInteger();

    ConnectionPoolStatistics(ConnectionPoolOpenedEvent event) {
        this.serverAddress = event.getServerId().getAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public int getWaitQueueSize() {
        return this.waitQueueSize.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionAdded(ConnectionAddedEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionRemoved(ConnectionRemovedEvent event) {
        this.size.decrementAndGet();
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
        this.waitQueueSize.incrementAndGet();
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
        this.waitQueueSize.decrementAndGet();
    }
}

