/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.relocations.com.mongodb.connection.ClusterConnectionMode;
import net.impactdev.impactor.relocations.com.mongodb.connection.ClusterDescription;
import net.impactdev.impactor.relocations.com.mongodb.connection.ServerDescription;
import net.impactdev.impactor.relocations.com.mongodb.selector.ServerSelector;

@Deprecated
public class LatencyMinimizingServerSelector
implements ServerSelector {
    private final long acceptableLatencyDifferenceNanos;

    public LatencyMinimizingServerSelector(long acceptableLatencyDifference, TimeUnit timeUnit) {
        this.acceptableLatencyDifferenceNanos = TimeUnit.NANOSECONDS.convert(acceptableLatencyDifference, timeUnit);
    }

    public long getAcceptableLatencyDifference(TimeUnit timeUnit) {
        return timeUnit.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.MULTIPLE) {
            return clusterDescription.getAny();
        }
        return this.getServersWithAcceptableLatencyDifference(clusterDescription.getAny(), this.getFastestRoundTripTimeNanos(clusterDescription.getServerDescriptions()));
    }

    public String toString() {
        return "LatencyMinimizingServerSelector{acceptableLatencyDifference=" + TimeUnit.MILLISECONDS.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS) + " ms" + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatencyMinimizingServerSelector that = (LatencyMinimizingServerSelector)o;
        return this.acceptableLatencyDifferenceNanos == that.acceptableLatencyDifferenceNanos;
    }

    public int hashCode() {
        return (int)(this.acceptableLatencyDifferenceNanos ^ this.acceptableLatencyDifferenceNanos >>> 32);
    }

    private long getFastestRoundTripTimeNanos(List<ServerDescription> members) {
        long fastestRoundTripTime = Long.MAX_VALUE;
        for (ServerDescription cur : members) {
            if (!cur.isOk() || cur.getRoundTripTimeNanos() >= fastestRoundTripTime) continue;
            fastestRoundTripTime = cur.getRoundTripTimeNanos();
        }
        return fastestRoundTripTime;
    }

    private List<ServerDescription> getServersWithAcceptableLatencyDifference(List<ServerDescription> servers, long bestPingTime) {
        ArrayList<ServerDescription> goodSecondaries = new ArrayList<ServerDescription>(servers.size());
        for (ServerDescription cur : servers) {
            if (!cur.isOk() || cur.getRoundTripTimeNanos() - this.acceptableLatencyDifferenceNanos > bestPingTime) continue;
            goodSecondaries.add(cur);
        }
        return goodSecondaries;
    }
}

