/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.okio;

import java.io.OutputStream;
import net.impactdev.impactor.relocations.kotlin.Metadata;
import net.impactdev.impactor.relocations.kotlin.jvm.internal.Intrinsics;
import net.impactdev.impactor.relocations.okio.Buffer;
import net.impactdev.impactor.relocations.okio.Segment;
import net.impactdev.impactor.relocations.okio.SegmentPool;
import net.impactdev.impactor.relocations.okio.Sink;
import net.impactdev.impactor.relocations.okio.Timeout;
import net.impactdev.impactor.relocations.okio._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/impactdev/impactor/relocations/okio/OutputStreamSink;", "Lnet/impactdev/impactor/relocations/okio/Sink;", "out", "Ljava/io/OutputStream;", "timeout", "Lnet/impactdev/impactor/relocations/okio/Timeout;", "(Ljava/io/OutputStream;Lokio/Timeout;)V", "close", "", "flush", "toString", "", "write", "source", "Lnet/impactdev/impactor/relocations/okio/Buffer;", "byteCount", "", "net.impactdev.impactor.relocations.okio"})
final class OutputStreamSink
implements Sink {
    @NotNull
    private final OutputStream out;
    @NotNull
    private final Timeout timeout;

    public OutputStreamSink(@NotNull OutputStream out, @NotNull Timeout timeout2) {
        Intrinsics.checkNotNullParameter(out, "out");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        this.out = out;
        this.timeout = timeout2;
    }

    @Override
    public void write(@NotNull Buffer source2, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter(source2, "source");
        _UtilKt.checkOffsetAndCount(source2.size(), 0L, byteCount);
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            Segment head;
            this.timeout.throwIfReached();
            Intrinsics.checkNotNull(source2.head);
            int b$iv = head.limit - head.pos;
            boolean $i$f$minOf = false;
            long l = b$iv;
            boolean bl = false;
            toCopy = (int)Math.min(remaining, l);
            this.out.write(head.data, head.pos, toCopy);
            Object object = head;
            ((Segment)object).pos += toCopy;
            object = source2;
            ((Buffer)object).setSize$okio(((Buffer)object).size() - (long)toCopy);
            if (head.pos != head.limit) continue;
            source2.head = head.pop();
            SegmentPool.recycle(head);
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.timeout;
    }

    @NotNull
    public String toString() {
        return "sink(" + this.out + ')';
    }
}

