/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.bson.codecs;

import net.impactdev.impactor.relocations.org.bson.Document;
import net.impactdev.impactor.relocations.org.bson.Transformer;
import net.impactdev.impactor.relocations.org.bson.assertions.Assertions;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonTypeClassMap;
import net.impactdev.impactor.relocations.org.bson.codecs.CodeWithScopeCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.Codec;
import net.impactdev.impactor.relocations.org.bson.codecs.DocumentCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecProvider;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecRegistry;
import net.impactdev.impactor.relocations.org.bson.types.CodeWithScope;

public class DocumentCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public DocumentCodecProvider() {
        this(new BsonTypeClassMap());
    }

    public DocumentCodecProvider(Transformer valueTransformer) {
        this(new BsonTypeClassMap(), valueTransformer);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = valueTransformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == CodeWithScope.class) {
            return new CodeWithScopeCodec(registry.get(Document.class));
        }
        if (clazz == Document.class) {
            return new DocumentCodec(registry, this.bsonTypeClassMap, this.valueTransformer);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCodecProvider that = (DocumentCodecProvider)o;
        if (!this.bsonTypeClassMap.equals(that.bsonTypeClassMap)) {
            return false;
        }
        return !(this.valueTransformer != null ? !this.valueTransformer.equals(that.valueTransformer) : that.valueTransformer != null);
    }

    public int hashCode() {
        int result = this.bsonTypeClassMap.hashCode();
        result = 31 * result + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return result;
    }
}

