/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec.LocalDateTimeCodec;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec.TimeCodec;

public class TimestampColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public TimestampColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Timestamp.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 93;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeTimestampText(buf, length, null);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeTimestampBinary(buf, length, null);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        if (length == 0) {
            StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
            if (this.getDecimals() > 0) {
                zeroValue.append(".");
                for (int i = 0; i < this.getDecimals(); ++i) {
                    zeroValue.append("0");
                }
            }
            return zeroValue.toString();
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte day = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && day == 0) {
            return "0000-00-00 00:00:00";
        }
        LocalDateTime dateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minutes, (int)seconds).plusNanos(microseconds * 1000L);
        StringBuilder microSecPattern = new StringBuilder();
        if (this.getDecimals() > 0 || microseconds > 0L) {
            int decimal = this.getDecimals() & 0xFF;
            if (decimal == 0) {
                decimal = 6;
            }
            microSecPattern.append(".");
            for (int i = 0; i < decimal; ++i) {
                microSecPattern.append("S");
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss" + microSecPattern);
        return dateTime.toLocalDate().toString() + ' ' + dateTime.toLocalTime().format(formatter);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        Timestamp timestamp;
        Calendar c;
        int begin;
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (begin = 0; begin < length; ++begin) {
            byte b = buf.readByte();
            if (b == 45 || b == 32 || b == 58) {
                ++partIdx;
                continue;
            }
            if (b == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b < 48 || b > 57) {
                buf.pos(pos);
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length), this.dataType}));
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            return null;
        }
        if (nanoBegin > 0) {
            for (begin = 0; begin < 6 - (length - nanoBegin - 1); ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
        }
        if (cal == null) {
            c = Calendar.getInstance();
            c.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
            timestamp = new Timestamp(c.getTime().getTime());
            timestamp.setNanos(timestampsPart[6] * 1000);
        } else {
            c = cal;
            synchronized (c) {
                cal.clear();
                cal.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                timestamp = new Timestamp(cal.getTime().getTime());
                timestamp.setNanos(timestampsPart[6] * 1000);
            }
        }
        String st = timestamp.toString();
        return Date.valueOf(st.substring(0, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        Calendar cal;
        Calendar calendar = cal = calParam == null ? Calendar.getInstance() : calParam;
        if (length == 0) {
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            return null;
        }
        Calendar calendar2 = cal;
        synchronized (calendar2) {
            cal.clear();
            cal.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
            timestamp = new Timestamp(cal.getTimeInMillis());
        }
        timestamp.setNanos((int)(microseconds * 1000L));
        String st = timestamp.toString();
        return Date.valueOf(st.substring(0, 10));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        LocalDateTime lt = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, this, cal);
        if (lt == null) {
            return null;
        }
        Calendar cc = cal == null ? Calendar.getInstance() : cal;
        ZonedDateTime d = TimeCodec.EPOCH_DATE.atTime(lt.toLocalTime()).atZone(cc.getTimeZone().toZoneId());
        return new Time(d.toEpochSecond() * 1000L + (long)(d.getNano() / 1000000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        if (length == 0) {
            return null;
        }
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0) {
            return null;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.set(1970, 0, 1, hour, minutes, seconds);
            return new Time(cal.getTimeInMillis() + microseconds / 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        int begin;
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (begin = 0; begin < length; ++begin) {
            byte b = buf.readByte();
            if (b == 45 || b == 32 || b == 58) {
                ++partIdx;
                continue;
            }
            if (b == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b < 48 || b > 57) {
                buf.pos(pos);
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length), this.dataType}));
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            return null;
        }
        if (nanoBegin > 0) {
            for (begin = 0; begin < 6 - (length - nanoBegin - 1); ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
        }
        if (calParam == null) {
            Calendar c = Calendar.getInstance();
            c.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
            timestamp = new Timestamp(c.getTime().getTime());
            timestamp.setNanos(timestampsPart[6] * 1000);
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                timestamp = new Timestamp(calParam.getTime().getTime());
                timestamp.setNanos(timestampsPart[6] * 1000);
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        if (length == 0) {
            return null;
        }
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            return null;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
            timestamp = new Timestamp(cal.getTimeInMillis());
        }
        timestamp.setNanos((int)(microseconds * 1000L));
        return timestamp;
    }
}

