/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class UnsignedTinyIntColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public UnsignedTinyIntColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (conf.tinyInt1isBit() && this.columnLength == 1L) {
            return Boolean.class.getName();
        }
        return Integer.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        if (conf.tinyInt1isBit() && this.columnLength == 1L) {
            return conf.transformedBitIsBoolean() ? 16 : -7;
        }
        return 5;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (conf.tinyInt1isBit() && this.columnLength == 1L) {
            return conf.transformedBitIsBoolean() ? "BOOLEAN" : "BIT";
        }
        return "TINYINT UNSIGNED";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        if (conf.tinyInt1isBit() && this.columnLength == 1L) {
            return this.decodeBooleanText(buf, length);
        }
        return (int)buf.atoull(length);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        if (conf.tinyInt1isBit() && this.columnLength == 1L) {
            return this.decodeBooleanBinary(buf, length);
        }
        return (int)buf.readUnsignedByte();
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        String s = buf.readAscii(length);
        return !"0".equals(s);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readByte() != 0;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.atoull(length);
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        long result = buf.readUnsignedByte();
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return String.valueOf(buf.readUnsignedByte());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        return (short)buf.atoull(length);
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readUnsignedByte();
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        return (int)buf.atoull(length);
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readUnsignedByte();
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.atoull(length);
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readUnsignedByte();
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readUnsignedByte();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        return buf.readUnsignedByte();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

